/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.key;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.security.saml.key.KeyManager;

public class JKSKeyManager
implements KeyManager {
    private final Logger log = LoggerFactory.getLogger(JKSKeyManager.class);
    private CredentialResolver credentialResolver;
    private KeyStore keyStore;
    private Set<String> availableKeys;
    private String defaultKey;

    public JKSKeyManager(KeyStore keyStore, Map<String, String> passwords, String defaultKey) {
        this.keyStore = keyStore;
        this.availableKeys = this.getAvailableKeys(keyStore);
        this.credentialResolver = new KeyStoreCredentialResolver(keyStore, passwords);
        this.defaultKey = defaultKey;
    }

    public JKSKeyManager(Resource storeFile, String storePass, Map<String, String> passwords, String defaultKey) {
        this.keyStore = this.initialize(storeFile, storePass, "JKS");
        this.availableKeys = this.getAvailableKeys(this.keyStore);
        this.credentialResolver = new KeyStoreCredentialResolver(this.keyStore, passwords);
        this.defaultKey = defaultKey;
    }

    private Set<String> getAvailableKeys(KeyStore keyStore) {
        try {
            HashSet<String> availableKeys = new HashSet<String>();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                availableKeys.add(aliases.nextElement());
            }
            return availableKeys;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Unable to load aliases from keyStore", e);
        }
    }

    private KeyStore initialize(Resource storeFile, String storePass, String storeType) {
        InputStream inputStream = null;
        try {
            inputStream = storeFile.getInputStream();
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(inputStream, storePass == null ? null : storePass.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            this.log.error("Error initializing key store", (Throwable)e);
            throw new RuntimeException("Error initializing keystore", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.debug("Error closing input stream for keystore.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        if (alias == null || alias.length() == 0) {
            return null;
        }
        try {
            return (X509Certificate)this.keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            this.log.error("Error loading certificate", (Throwable)e);
            return null;
        }
    }

    public PublicKey getPublicKey(String alias) {
        X509Certificate x509Certificate = this.getCertificate(alias);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public Iterable<Credential> resolve(CriteriaSet criteriaSet) throws SecurityException {
        return this.credentialResolver.resolve((Object)criteriaSet);
    }

    public Credential resolveSingle(CriteriaSet criteriaSet) throws SecurityException {
        return (Credential)this.credentialResolver.resolveSingle((Object)criteriaSet);
    }

    @Override
    public Credential getCredential(String keyName) {
        if (keyName == null) {
            keyName = this.defaultKey;
        }
        try {
            CriteriaSet cs = new CriteriaSet();
            EntityIDCriteria criteria = new EntityIDCriteria(keyName);
            cs.add((Object)criteria);
            return this.resolveSingle(cs);
        }
        catch (SecurityException e) {
            throw new SAMLRuntimeException("Can't obtain SP signing key", (Exception)((Object)e));
        }
    }

    @Override
    public Credential getDefaultCredential() {
        return this.getCredential(null);
    }

    @Override
    public String getDefaultCredentialName() {
        return this.defaultKey;
    }

    @Override
    public Set<String> getAvailableCredentials() {
        return this.availableKeys;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }
}

