/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.data;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.AbstractInMemoryContainer;
import com.vaadin.v7.data.util.VaadinPropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectableItem;

public class SelectableBeanItemContainer<T>
extends AbstractInMemoryContainer<T, String, SelectableItem<T>> {
    private final Map<T, SelectableItem<T>> itemIdToItem = new HashMap<T, SelectableItem<T>>();
    private final Map<String, VaadinPropertyDescriptor> model;
    private final Class<? super T> type;

    public SelectableBeanItemContainer(Class<? super T> type) {
        this.model = SelectableItem.getPropertyDescriptors(type);
        this.type = type;
    }

    protected SelectableItem<T> getUnfilteredItem(Object itemId) {
        return this.itemIdToItem.get(itemId);
    }

    public Collection<String> getContainerPropertyIds() {
        return this.model.keySet();
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        Item item = this.getItem(itemId);
        if (item == null) {
            return null;
        }
        return item.getItemProperty(propertyId);
    }

    public Class<?> getType(Object propertyId) {
        return this.model.get(propertyId).getPropertyType();
    }

    private boolean isValid(Object itemId) {
        return itemId != null && this.type.isAssignableFrom(itemId.getClass());
    }

    public Item addItemAt(int index, Object newItemId) {
        if (!this.isValid(newItemId)) {
            return null;
        }
        return this.internalAddItemAt(index, newItemId, (Item)this.createItem(newItemId), true);
    }

    private SelectableItem<T> createItem(T itemId) {
        if (itemId == null) {
            return null;
        }
        return new SelectableItem<T>(itemId, this.model);
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) {
        if (!this.isValid(previousItemId) || !this.isValid(newItemId)) {
            return null;
        }
        return this.internalAddItemAfter(previousItemId, newItemId, (Item)this.createItem(newItemId), true);
    }

    public Item addItem(Object itemId) {
        if (!this.isValid(itemId)) {
            return null;
        }
        return this.internalAddItemAtEnd(itemId, (Item)this.createItem(itemId), true);
    }

    public boolean removeItem(Object itemId) {
        int position = this.indexOfId(itemId);
        if (this.internalRemoveItem(itemId)) {
            this.itemIdToItem.remove(itemId);
            this.fireItemRemoved(position, itemId);
            return true;
        }
        return false;
    }

    public boolean removeAllItems() {
        this.internalRemoveAllItems();
        this.itemIdToItem.clear();
        this.fireItemSetChange();
        return true;
    }

    protected void registerNewItem(int position, T itemId, SelectableItem<T> item) {
        this.itemIdToItem.put(itemId, item);
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding container properties not supported. Override the addContainerProperty() method if required.");
    }

    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing container properties not supported. Override the addContainerProperty() method if required.");
    }

    public boolean isSelected(T itemId) {
        return this.itemIdToItem.get(itemId).isSelected();
    }

    public Collection<T> getSelectedAttributes() {
        return Collections2.filter(this.itemIdToItem.keySet(), (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return SelectableBeanItemContainer.this.isSelected(input);
            }
        });
    }

    public void selectAllItems(boolean select) {
        for (Object eachItemId : this.getItemIds()) {
            this.itemIdToItem.get(eachItemId).setSelected(select);
        }
        this.fireItemSetChange();
    }
}

