/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImmutableCollections<T> {
    private final Function<T, T> immutableInstanceFactory;

    private ImmutableCollections(Function<T, T> immutableInstanceFactory) {
        this.immutableInstanceFactory = immutableInstanceFactory;
    }

    public static <T> ImmutableCollections<T> with(Function<T, T> immutableInstanceFactory) {
        return new ImmutableCollections<T>(Objects.requireNonNull(immutableInstanceFactory));
    }

    public List<T> newList(Collection<T> toCopy) {
        if (toCopy == null || toCopy.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.toStreamOfImmutables(toCopy).collect(Collectors.toList()));
    }

    public static <T> List<T> newListOfImmutableType(Collection<T> toCopy) {
        if (toCopy == null || toCopy.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(toCopy));
    }

    public static <T> Set<T> newSetOfImmutableType(Collection<T> toCopy) {
        if (toCopy == null || toCopy.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<T>(toCopy));
    }

    public static <T, S> Map<T, S> newMapOfImmutableTypes(Map<T, S> toCopy, Supplier<Map<T, S>> mapSupplier) {
        if (toCopy == null || toCopy.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<T, S> map = mapSupplier.get();
        map.putAll(toCopy);
        return Collections.unmodifiableMap(map);
    }

    public static <T, S> Map<T, S> newMapOfImmutableTypes(Map<T, S> toCopy) {
        return ImmutableCollections.newMapOfImmutableTypes(toCopy, HashMap::new);
    }

    private Stream<T> toStreamOfImmutables(Collection<T> toCopy) {
        return toCopy.stream().map(this.immutableInstanceFactory);
    }
}

