/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.walker;

import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaTotalDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaWhiteSpaceFacet;

public class XmlSchemaRestriction {
    private Type type;
    private Object value;
    private boolean isFixed;

    XmlSchemaRestriction(XmlSchemaFacet facet) {
        if (facet instanceof XmlSchemaEnumerationFacet) {
            this.type = Type.ENUMERATION;
        } else if (facet instanceof XmlSchemaMaxExclusiveFacet) {
            this.type = Type.EXCLUSIVE_MAX;
        } else if (facet instanceof XmlSchemaMaxInclusiveFacet) {
            this.type = Type.INCLUSIVE_MAX;
        } else if (facet instanceof XmlSchemaMinExclusiveFacet) {
            this.type = Type.EXCLUSIVE_MIN;
        } else if (facet instanceof XmlSchemaMinInclusiveFacet) {
            this.type = Type.INCLUSIVE_MIN;
        } else if (facet instanceof XmlSchemaFractionDigitsFacet) {
            this.type = Type.DIGITS_FRACTION;
        } else if (facet instanceof XmlSchemaTotalDigitsFacet) {
            this.type = Type.DIGITS_TOTAL;
        } else if (facet instanceof XmlSchemaPatternFacet) {
            this.type = Type.PATTERN;
        } else if (facet instanceof XmlSchemaWhiteSpaceFacet) {
            this.type = Type.WHITESPACE;
        } else if (facet instanceof XmlSchemaLengthFacet) {
            this.type = Type.LENGTH;
        } else if (facet instanceof XmlSchemaMinLengthFacet) {
            this.type = Type.LENGTH_MIN;
        } else if (facet instanceof XmlSchemaMaxLengthFacet) {
            this.type = Type.LENGTH_MAX;
        } else {
            throw new IllegalArgumentException("Unrecognized facet " + facet.getClass().getName());
        }
        this.value = facet.getValue();
        this.isFixed = facet.isFixed();
    }

    public XmlSchemaRestriction(Type type) {
        this.type = type;
        this.value = null;
        this.isFixed = false;
    }

    public XmlSchemaRestriction(Type type, Object value, boolean isFixed) {
        this.type = type;
        this.value = value;
        this.isFixed = isFixed;
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        if (this.type != null && (this.type == Type.ENUMERATION || this.type == Type.PATTERN)) {
            result = 31 * result + (this.isFixed ? 1231 : 1237);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlSchemaRestriction other = (XmlSchemaRestriction)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.type != null && (this.type == Type.ENUMERATION || this.type == Type.PATTERN)) {
            if (this.isFixed != other.isFixed) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.type.name() + ": " + this.value + " (Fixed: " + this.isFixed + ")";
    }

    public static enum Type {
        ENUMERATION,
        EXCLUSIVE_MIN,
        EXCLUSIVE_MAX,
        INCLUSIVE_MIN,
        INCLUSIVE_MAX,
        PATTERN,
        WHITESPACE,
        LENGTH,
        LENGTH_MAX,
        LENGTH_MIN,
        DIGITS_FRACTION,
        DIGITS_TOTAL;

    }
}

