/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.docpath.XmlSchemaNamespaceContext;
import org.apache.ws.commons.schema.docpath.XmlSchemaStateMachineNode;
import org.apache.ws.commons.schema.walker.XmlSchemaAttrInfo;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DomBuilderFromSax
extends DefaultHandler {
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_SCHEMALOC = "schemaLocation";
    private static final String XSI_NIL = "nil";
    private Document document;
    private StringBuilder content;
    private Map<String, String> namespaceToLocationMapping;
    private List<String> newPrefixes;
    private XmlSchemaNamespaceContext nsContext;
    private Map<QName, XmlSchemaStateMachineNode> elementsByQName;
    private final ArrayList<Element> elementStack;
    private final DocumentBuilder docBuilder;
    private final XmlSchemaCollection schemas;
    private final Set<String> globalNamespaces;

    public DomBuilderFromSax(XmlSchemaCollection xmlSchemaCollection) throws ParserConfigurationException {
        if (xmlSchemaCollection == null) {
            throw new IllegalArgumentException("xmlSchemaCollection cannot be null.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setNamespaceAware(true);
        this.docBuilder = factory.newDocumentBuilder();
        this.elementStack = new ArrayList();
        this.newPrefixes = new ArrayList<String>();
        this.nsContext = new XmlSchemaNamespaceContext();
        this.document = null;
        this.content = null;
        this.namespaceToLocationMapping = null;
        this.elementsByQName = null;
        this.schemas = xmlSchemaCollection;
        this.globalNamespaces = new HashSet<String>();
        this.globalNamespaces.add(XSI_NS);
    }

    @Override
    public void startDocument() throws SAXException {
        this.document = this.docBuilder.newDocument();
        this.document.setXmlStandalone(true);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsContext.addNamespace(prefix, uri);
        this.newPrefixes.add(prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.nsContext.removeNamespace(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.addContentToCurrentElement(false);
        Element element = this.document.createElementNS(uri.length() == 0 ? null : uri, qName);
        for (String newPrefix : this.newPrefixes) {
            String namespace = this.nsContext.getNamespaceURI(newPrefix);
            if (namespace == null) {
                throw new SAXException("Prefix " + newPrefix + " is not recognized.");
            }
            String qualifiedName = null;
            qualifiedName = newPrefix.length() > 0 ? "xmlns:" + newPrefix : "xmlns";
            try {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", qualifiedName, namespace);
            }
            catch (DOMException e) {
                throw new IllegalStateException("Cannot add namespace attribute ns=\"http://www.w3.org/2000/xmlns/\", qn=\"" + qualifiedName + "\", value=\"" + namespace + "\" to element \"" + qName + "\".", e);
            }
        }
        this.newPrefixes.clear();
        QName elemQName = new QName(uri, localName);
        XmlSchemaStateMachineNode stateMachine = null;
        if (this.elementsByQName != null) {
            stateMachine = this.elementsByQName.get(elemQName);
        }
        for (int attrIndex = 0; attrIndex < atts.getLength(); ++attrIndex) {
            String attrUri = atts.getURI(attrIndex);
            if (attrUri.length() == 0) {
                attrUri = null;
            }
            boolean isGlobal = this.globalNamespaces.contains(attrUri);
            if (attrUri != null && !isGlobal) {
                QName attrQName = new QName(attrUri, atts.getLocalName(attrIndex));
                boolean found = false;
                if (stateMachine != null) {
                    for (XmlSchemaAttrInfo attrInfo : stateMachine.getAttributes()) {
                        if (!attrInfo.getAttribute().getQName().equals(attrQName)) continue;
                        found = true;
                        isGlobal = attrInfo.isTopLevel();
                    }
                }
                if (!found && this.schemas.getAttributeByQName(attrQName) != null) {
                    isGlobal = true;
                }
            }
            String attrValue = atts.getValue(attrIndex);
            if (!isGlobal) {
                element.setAttribute(atts.getLocalName(attrIndex), attrValue);
                continue;
            }
            element.setAttributeNS(attrUri, atts.getQName(attrIndex), attrValue);
        }
        if (!this.elementStack.isEmpty()) {
            this.elementStack.get(this.elementStack.size() - 1).appendChild(element);
        } else {
            this.addNamespaceLocationMappings(element);
            this.document.appendChild(element);
        }
        this.elementStack.add(element);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.content == null) {
            this.content = new StringBuilder();
        }
        this.content.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean namespacesMatch;
        this.addContentToCurrentElement(true);
        if (this.elementStack.isEmpty()) {
            StringBuilder errMsg = new StringBuilder("Attempted to end element {");
            errMsg.append(uri).append('}').append(localName);
            errMsg.append(", but the stack is empty!");
            throw new IllegalStateException(errMsg.toString());
        }
        Element element = this.elementStack.remove(this.elementStack.size() - 1);
        String ns = uri.length() == 0 ? null : uri;
        boolean bl = namespacesMatch = ns == null && element.getNamespaceURI() == null || ns != null && ns.equals(element.getNamespaceURI());
        if (!namespacesMatch || !element.getLocalName().equals(localName)) {
            StringBuilder errMsg = new StringBuilder("Attempted to end element {");
            errMsg.append(ns).append('}').append(localName).append(", but found {");
            errMsg.append(element.getNamespaceURI()).append('}');
            errMsg.append(element.getLocalName()).append(" on the stack instead!");
            throw new IllegalStateException(errMsg.toString());
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.elementStack.isEmpty()) {
            StringBuilder errMsg = new StringBuilder("Ending an XML document with ");
            errMsg.append(this.elementStack.size()).append(" elements still open.");
            this.elementStack.clear();
            throw new IllegalStateException(errMsg.toString());
        }
    }

    private void addContentToCurrentElement(boolean isEnd) {
        if (this.content == null || this.content.length() == 0) {
            Element currElem;
            if (isEnd && !this.elementStack.isEmpty() && this.schemas != null && (currElem = this.elementStack.get(this.elementStack.size() - 1)).getChildNodes().getLength() == 0) {
                XmlSchemaStateMachineNode stateMachine;
                QName elemQName = new QName(currElem.getNamespaceURI(), currElem.getLocalName());
                XmlSchemaElement schemaElem = null;
                if (this.elementsByQName != null && (stateMachine = this.elementsByQName.get(elemQName)) != null && stateMachine.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) {
                    schemaElem = stateMachine.getElement();
                }
                if (schemaElem == null) {
                    schemaElem = this.schemas.getElementByQName(elemQName);
                }
                if (schemaElem != null && schemaElem.isNillable()) {
                    currElem.setAttributeNS(XSI_NS, XSI_NIL, "true");
                }
            }
            return;
        }
        if (this.elementStack.isEmpty()) {
            StringBuilder errMsg = new StringBuilder("Attempted to add content \"");
            errMsg.append(this.content.toString()).append("\", but there were no ");
            errMsg.append("elements in the stack!");
            throw new IllegalStateException(errMsg.toString());
        }
        this.elementStack.get(this.elementStack.size() - 1).appendChild(this.document.createTextNode(this.content.toString()));
        this.content.delete(0, this.content.length());
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<String, String> getNamespaceToLocationMapping() {
        return this.namespaceToLocationMapping;
    }

    public void setNamespaceToLocationMapping(Map<String, String> nsToLocMapping) {
        this.namespaceToLocationMapping = nsToLocMapping;
    }

    public Map<QName, XmlSchemaStateMachineNode> getStateMachinesByQName() {
        return this.elementsByQName;
    }

    public void setStateMachinesByQName(Map<QName, XmlSchemaStateMachineNode> statesByQName) {
        this.elementsByQName = statesByQName;
    }

    private void addNamespaceLocationMappings(Element rootElement) {
        if (this.namespaceToLocationMapping == null || this.namespaceToLocationMapping.isEmpty() || rootElement.hasAttributeNS(XSI_NS, XSI_SCHEMALOC)) {
            return;
        }
        StringBuilder schemaList = new StringBuilder();
        for (Map.Entry<String, String> e : this.namespaceToLocationMapping.entrySet()) {
            schemaList.append(e.getKey()).append(' ').append(e.getValue());
            schemaList.append(' ');
        }
        schemaList.delete(schemaList.length() - 1, schemaList.length());
        rootElement.setAttributeNS(XSI_NS, XSI_SCHEMALOC, schemaList.toString());
    }
}

