/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.common.pollers;

import com.google.common.base.Enums;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.integration.api.v1.pollers.PollerRequestBuilder;
import org.opennms.integration.api.v1.pollers.PollerResult;
import org.opennms.integration.api.v1.pollers.Status;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.support.SimpleMonitoredService;

public class PollerRequestBuilderImpl
implements PollerRequestBuilder {
    private String className;
    private InetAddress address;
    private String location;
    private String serviceName;
    private Long ttlInMs;
    private Map<String, String> attributes = new HashMap<String, String>();
    private final LocationAwarePollerClient pollerClient;

    public PollerRequestBuilderImpl(LocationAwarePollerClient pollerClient) {
        this.pollerClient = pollerClient;
    }

    public PollerRequestBuilder withPollerClassName(String className) {
        this.className = className;
        return this;
    }

    public PollerRequestBuilder withAddress(InetAddress address) {
        this.address = address;
        return this;
    }

    public PollerRequestBuilder withLocation(String location) {
        this.location = location;
        return this;
    }

    public PollerRequestBuilder withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public PollerRequestBuilder withAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public PollerRequestBuilder withAttributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public PollerRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public CompletableFuture<PollerResult> execute() {
        Map<String, String> props = Collections.unmodifiableMap(this.attributes);
        SimpleMonitoredService service = new SimpleMonitoredService(this.address, this.serviceName, this.location);
        CompletableFuture future = this.pollerClient.poll().withService((MonitoredService)service).withMonitorClassName(this.className).withTimeToLive(this.ttlInMs).withAttributes(props).execute();
        CompletableFuture<PollerResult> result = new CompletableFuture<PollerResult>();
        try {
            PollerResponse pollerResponse = (PollerResponse)future.get();
            result.complete(new PollerResultImpl(pollerResponse.getPollStatus()));
        }
        catch (InterruptedException | ExecutionException e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private class PollerResultImpl
    implements PollerResult {
        private final Status status;
        private String reason;
        private Map<String, Number> properties;

        private PollerResultImpl(PollStatus pollStatus) {
            this.status = (Status)Enums.getIfPresent(Status.class, (String)pollStatus.getStatusName()).or((Object)Status.Unknown);
            if (this.status.equals((Object)Status.Up)) {
                this.properties = pollStatus.getProperties();
            } else {
                this.reason = pollStatus.getReason();
            }
        }

        public Status getStatus() {
            return this.status;
        }

        public String getReason() {
            return this.reason;
        }

        public Map<String, Number> getProperties() {
            return this.properties;
        }
    }
}

