/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.common.health;

import java.util.Arrays;
import java.util.List;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.features.apilayer.common.utils.InterfaceMapper;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.osgi.framework.BundleContext;

public class HealthCheckManager
extends InterfaceMapper<org.opennms.integration.api.v1.health.HealthCheck, HealthCheck> {
    public HealthCheckManager(BundleContext bundleContext) {
        super(HealthCheck.class, bundleContext);
    }

    @Override
    public HealthCheck map(final org.opennms.integration.api.v1.health.HealthCheck healthCheck) {
        return new HealthCheck(){

            public String getDescription() {
                return healthCheck.getDescription();
            }

            public List<String> getTags() {
                return Arrays.asList("local");
            }

            public org.opennms.core.health.api.Response perform(final Context context) throws Exception {
                Response response = healthCheck.perform(new org.opennms.integration.api.v1.health.Context(){

                    public long getTimeout() {
                        return context.getTimeout();
                    }
                });
                return HealthCheckManager.toResponse(response);
            }
        };
    }

    private static org.opennms.core.health.api.Response toResponse(Response response) {
        return new org.opennms.core.health.api.Response(HealthCheckManager.toStatus(response.getStatus()), response.getMessage());
    }

    private static org.opennms.core.health.api.Status toStatus(Status status) {
        switch (status) {
            case Starting: {
                return org.opennms.core.health.api.Status.Starting;
            }
            case Success: {
                return org.opennms.core.health.api.Status.Success;
            }
            case Timeout: {
                return org.opennms.core.health.api.Status.Timeout;
            }
            case Failure: {
                return org.opennms.core.health.api.Status.Failure;
            }
        }
        return org.opennms.core.health.api.Status.Unknown;
    }
}

