/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.password;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jasypt.util.password.StrongPasswordEncryptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Password {
    public static void main(String[] args) {
        File file;
        String OPENNMS_HOME = System.getProperty("opennms.home");
        System.Logger log = System.getLogger(Password.class.getName());
        if (args.length < 2) {
            log.log(System.Logger.Level.WARNING, "usage: password.jar <username> <password>");
            System.exit(1);
        }
        Path usersXml = Paths.get(OPENNMS_HOME, "etc", "users.xml");
        String userId = args[0];
        String newPassword = args[1];
        if (OPENNMS_HOME.isEmpty() || userId.isEmpty() || newPassword.isEmpty()) {
            log.log(System.Logger.Level.ERROR, "Unable to determine OpenNMS home, or no username or password was provided.");
            System.exit(1);
        }
        if (!(file = usersXml.toFile()).exists()) {
            log.log(System.Logger.Level.ERROR, "users.xml does not exist!");
            System.exit(1);
        }
        boolean foundUser = false;
        StrongPasswordEncryptor passwordEncryptor = new StrongPasswordEncryptor();
        String encryptedPassword = "";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("user");
            for (int itr = 0; itr < nodeList.getLength(); ++itr) {
                Element eElement;
                Node node = nodeList.item(itr);
                if (node.getNodeType() != 1 || !userId.contains((eElement = (Element)node).getElementsByTagName("user-id").item(0).getTextContent())) continue;
                foundUser = true;
                encryptedPassword = passwordEncryptor.encryptPassword(newPassword);
                eElement.getElementsByTagName("password").item(0).setTextContent(encryptedPassword);
            }
            if (foundUser) {
                DOMSource domSource = new DOMSource(doc);
                StreamResult sr = new StreamResult(file);
                try {
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer tf = factory.newTransformer();
                    tf.setOutputProperty("omit-xml-declaration", "yes");
                    tf.setOutputProperty("method", "xml");
                    tf.transform(domSource, sr);
                }
                catch (TransformerException | TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                }
            } else {
                log.log(System.Logger.Level.ERROR, "User ID couldn't found.");
                System.exit(1);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }
}

