/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.config.upgrade;

import java.sql.Connection;
import java.util.Objects;
import liquibase.Liquibase;
import liquibase.change.ChangeFactory;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext2.cm.change.ChangeSchema;
import liquibase.ext2.cm.change.ImportConfiguration;
import liquibase.ext2.cm.change.ImportConfigurations;
import liquibase.ext2.cm.change.RegisterSchema;
import liquibase.ext2.cm.change.UpgradeSchema;
import liquibase.ext2.cm.database.CmDatabase;
import liquibase.ext2.cm.executor.CmExecutor;
import liquibase.ext2.cm.sqlgenerator.CmSqlGenerator;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import org.opennms.features.config.service.api.ConfigurationManagerService;

public class LiquibaseUpgrader {
    public static final String TABLE_NAME_DATABASECHANGELOG = "cm_databasechangelog";
    public static final String TABLE_NAME_DATABASECHANGELOGLOCK = "cm_databasechangeloglock";
    private final ConfigurationManagerService cm;

    public LiquibaseUpgrader(ConfigurationManagerService cm) {
        this.cm = Objects.requireNonNull(cm);
    }

    public void runChangelog(String changelog, Connection sqlConnection) throws LiquibaseException {
        CmDatabase db = new CmDatabase(this.cm);
        DatabaseFactory.getInstance().register((Database)db);
        db.setConnection((DatabaseConnection)new JdbcConnection(sqlConnection));
        db.setDatabaseChangeLogTableName(TABLE_NAME_DATABASECHANGELOG);
        db.setDatabaseChangeLogLockTableName(TABLE_NAME_DATABASECHANGELOGLOCK);
        ChangeFactory.getInstance().register(RegisterSchema.class);
        ChangeFactory.getInstance().register(UpgradeSchema.class);
        ChangeFactory.getInstance().register(ImportConfiguration.class);
        ChangeFactory.getInstance().register(ImportConfigurations.class);
        ChangeFactory.getInstance().register(ChangeSchema.class);
        ExecutorService.getInstance().clearExecutor((Database)db);
        CmExecutor executor = new CmExecutor();
        executor.setDatabase((Database)db);
        ExecutorService.getInstance().setExecutor((Database)db, (Executor)executor);
        SqlGeneratorFactory.getInstance().register((SqlGenerator)new CmSqlGenerator());
        Liquibase liquibase = new Liquibase(changelog, (ResourceAccessor)new ClassLoaderResourceAccessor(LiquibaseUpgrader.class.getClassLoader()), (Database)db);
        liquibase.update((String)null);
    }
}

