/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change.types;

import java.util.List;
import java.util.Optional;
import liquibase.parser.core.ParsedNode;
import org.opennms.features.config.dao.api.ConfigItem;

public abstract class AbstractPropertyType {
    protected final List<ParsedNode> listOfAttributes;
    protected final ConfigItem configItem;
    protected final Optional<String> defaultValueOpt;

    protected AbstractPropertyType(List<ParsedNode> listOfAttributes) {
        this.listOfAttributes = listOfAttributes;
        this.configItem = new ConfigItem();
        this.configItem.setName(this.getAttributeValueNotBlankOrThrowException("name"));
        this.defaultValueOpt = this.getAttributeValue("default");
    }

    public ConfigItem toItem() {
        return this.configItem;
    }

    public String getAttributeValueNotBlankOrThrowException(String name) {
        return this.getAttributeValue(name).filter(s -> !s.isBlank()).orElseThrow(() -> new IllegalArgumentException(String.format("Attribute %s must not be blank.", name)));
    }

    public Optional<String> getAttributeValue(String name) {
        return this.listOfAttributes.stream().filter(n -> name.equals(n.getName())).findAny().map(ParsedNode::getValue).map(Object::toString);
    }

    public static interface Attribute {
        public static final String NAME = "name";
        public static final String DEFAULT = "default";
        public static final String PATTERN = "pattern";
        public static final String MIN = "min";
        public static final String MAX = "max";
        public static final String TYPE = "type";
    }
}

