/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext2.cm.change.AbstractCmChange;
import liquibase.ext2.cm.change.ConfigFileUtil;
import liquibase.ext2.cm.change.ImportConfigurationUtil;
import liquibase.ext2.cm.database.CmDatabase;
import liquibase.ext2.cm.statement.GenericCmStatement;
import liquibase.statement.SqlStatement;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.util.Substring;
import org.springframework.core.io.Resource;

@DatabaseChange(name="importConfigs", description="Imports configurations. Only osgi (.cfg) files are supported.", priority=5)
public class ImportConfigurations
extends AbstractCmChange {
    private static final Set<String> ALLOWED_EXTENSIONS = Set.of("cfg");
    private String schemaId;
    private String filePath;
    private Path archivePath;
    private Collection<Resource> configResources;

    @Override
    public ValidationErrors validate(CmDatabase db, ValidationErrors validationErrors) {
        validationErrors.checkRequiredField("schemaId", (Object)this.schemaId);
        validationErrors.checkRequiredField("filePath", (Object)this.filePath);
        ConfigFileUtil.checkFileType(validationErrors, ALLOWED_EXTENSIONS, this.filePath);
        this.checkForWildcard(validationErrors);
        this.configResources = ConfigFileUtil.findConfigFiles(this.filePath);
        for (Resource resource : this.configResources) {
            if (resource.isReadable()) continue;
            validationErrors.addError("Found configuration file but can not read it: " + resource.getFilename());
        }
        this.archivePath = ConfigFileUtil.validateAndGetArchiveDir(validationErrors);
        return validationErrors;
    }

    void checkForWildcard(ValidationErrors validationErrors) {
        if (this.filePath == null) {
            return;
        }
        if (!this.filePath.endsWith("-*.cfg")) {
            validationErrors.addError(String.format("filePath doesn't end in '-*.cfg', check your filePath: %s", this.filePath));
        }
    }

    public String getConfirmationMessage() {
        if (this.configResources.isEmpty()) {
            return String.format("No configurations files found with pattern %s for schema=%s.", this.filePath, this.schemaId);
        }
        return String.format("Imported configurations with pattern %s for schema=%s:%n%s", this.filePath, this.schemaId, this.configResources.stream().map(Resource::getFilename).collect(Collectors.joining("%n")));
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new GenericCmStatement(this::importConfigs)};
    }

    private void importConfigs(ConfigurationManagerService cm) {
        for (Resource config : this.configResources) {
            String configId = new Substring(config.getFilename()).getAfterLast("-").getBeforeLast(".cfg").toString();
            ImportConfigurationUtil.importConfig(cm, config, new ConfigUpdateInfo(this.schemaId, configId), this.archivePath);
        }
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

