/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext2.cm.change.AbstractCmChange;
import liquibase.ext2.cm.change.Liqui2ConfigItemUtil;
import liquibase.ext2.cm.database.CmDatabase;
import liquibase.ext2.cm.statement.GenericCmStatement;
import liquibase.parser.core.ParsedNode;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.opennms.features.config.dao.api.ConfigItem;
import org.opennms.features.config.dao.impl.util.OpenAPIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DatabaseChange(name="changeSchema", description="Changes an existing schema.", priority=5)
public class ChangeSchema
extends AbstractCmChange {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeSchema.class);
    private String schemaId;
    private final List<String> validationErrorsWhileParsing = new ArrayList<String>();
    private List<Consumer<OpenAPIBuilder>> changes = new ArrayList<Consumer<OpenAPIBuilder>>();
    private List<String> changeLog = new ArrayList<String>();

    @Override
    protected ValidationErrors validate(CmDatabase database, ValidationErrors validationErrors) {
        validationErrors.checkRequiredField("schemaId", (Object)this.schemaId);
        this.validationErrorsWhileParsing.forEach(arg_0 -> ((ValidationErrors)validationErrors).addError(arg_0));
        return validationErrors;
    }

    public String getConfirmationMessage() {
        String modifications = String.join((CharSequence)"\n", this.changeLog);
        return String.format("Changed schema %s:%n%s", this.schemaId, modifications);
    }

    public SqlStatement[] generateStatements(Database database) {
        LOG.info("Change schema {}", (Object)this.schemaId);
        return new SqlStatement[]{new GenericCmStatement(cm -> {
            Optional definitionOpt = null;
            definitionOpt = ((CmDatabase)database).getConfigurationManager().getRegisteredConfigDefinition(this.schemaId);
            ConfigDefinition definition = definitionOpt.orElseGet(() -> {
                ConfigDefinition newDefinition = new ConfigDefinition(this.schemaId, Boolean.valueOf(false));
                newDefinition.setConfigName(this.schemaId);
                cm.registerConfigDefinition(this.schemaId, newDefinition);
                return newDefinition;
            });
            OpenAPIBuilder builder = OpenAPIBuilder.createBuilder((String)this.schemaId, (String)this.schemaId, (String)"/rest/cm", (OpenAPI)definition.getSchema());
            for (Consumer<OpenAPIBuilder> change : this.changes) {
                change.accept(builder);
            }
            definition.setSchema(builder.build(false));
            cm.changeConfigDefinition(this.schemaId, definition);
        })};
    }

    protected void customLoadLogic(ParsedNode parsedNode, ResourceAccessor resourceAccessor) {
        for (ParsedNode node : parsedNode.getChildren()) {
            if ("put".equals(node.getName())) {
                this.handlePut(node);
                continue;
            }
            if (!"delete".equals(node.getName())) continue;
            this.handleDelete(node);
        }
    }

    private void handlePut(ParsedNode node) {
        try {
            ConfigItem newPropertyDefinition = Liqui2ConfigItemUtil.createConfigItemForProperty(node.getChildren());
            Consumer<OpenAPIBuilder> change = schema -> ChangeSchema.put(schema, newPropertyDefinition);
            this.changes.add(change);
        }
        catch (IllegalArgumentException e) {
            this.validationErrorsWhileParsing.add(e.getMessage());
        }
    }

    static void put(OpenAPIBuilder schema, ConfigItem newPropertyDefinition) {
        schema.removeAttribute(newPropertyDefinition.getName());
        schema.addAttribute(newPropertyDefinition);
    }

    private void handleDelete(ParsedNode node) {
        try {
            String name = Liqui2ConfigItemUtil.getAttributeValueOrThrowException(node.getChildren(), "name");
            this.changeLog.add(String.format("DELETE: name=%s", name));
            Consumer<OpenAPIBuilder> change = openApi -> openApi.removeAttribute(name);
            this.changes.add(change);
        }
        catch (IllegalArgumentException e) {
            this.validationErrorsWhileParsing.add(e.getMessage());
        }
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }
}

