/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.Collections;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeResourceType
extends ResourceType {
    private static final Logger LOG = LoggerFactory.getLogger(NodeResourceType.class);
    private NodeInfo m_nodeInfo;

    public NodeResourceType(SnmpCollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        super(agent, snmpCollection);
        this.m_nodeInfo = new NodeInfo(this, agent);
    }

    public NodeInfo getNodeInfo() {
        return this.m_nodeInfo;
    }

    @Override
    public SnmpCollectionResource findResource(SnmpInstId inst) {
        return this.m_nodeInfo;
    }

    @Override
    public SnmpCollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        LOG.debug("findAliasedResource: Should not get called from NodeResourceType");
        return null;
    }

    public Collection<NodeInfo> getResources() {
        return Collections.singleton(this.m_nodeInfo);
    }

    @Override
    protected Collection<SnmpAttributeType> loadAttributeTypes() {
        return this.getCollection().getNodeAttributeTypes(this.getAgent());
    }
}

