/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckError;
import org.hibernate.validator.ap.util.CollectionHelper;

public class StaticCheck
extends AbstractConstraintCheck {
    @Override
    public Set<ConstraintCheckError> checkField(VariableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, "STATIC_FIELDS_MAY_NOT_BE_ANNOTATED");
    }

    @Override
    public Set<ConstraintCheckError> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, "STATIC_METHODS_MAY_NOT_BE_ANNOTATED");
    }

    private Set<ConstraintCheckError> checkInternal(Element element, AnnotationMirror annotation, String messageKey) {
        if (this.isStaticElement(element)) {
            return CollectionHelper.asSet(new ConstraintCheckError(element, annotation, messageKey, new Object[0]));
        }
        return Collections.emptySet();
    }

    private boolean isStaticElement(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }
}

