/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpNetToMediaTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IpNetToMediaTableTracker.class);
    public static final SnmpObjId IPNETTOMEDIA_TABLE_ENTRY_OID = SnmpObjId.get((String)".1.3.6.1.2.1.4.22.1");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_IFINDEX_OID = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY_OID, (String)"1");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_PHYSADDR_OID = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY_OID, (String)"2");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_NETADDR_OID = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY_OID, (String)"3");
    public static final SnmpObjId IPNETTOMEDIA_TABLE_TYPE_OID = SnmpObjId.get((SnmpObjId)IPNETTOMEDIA_TABLE_ENTRY_OID, (String)"4");
    public static final String IPNETTOMEDIA_TABLE_IFINDEX = "ipNetToMediaIfIndex";
    public static final String IPNETTOMEDIA_TABLE_PHYSADDR = "ipNetToMediaPhysAddress";
    public static final String IPNETTOMEDIA_TABLE_NETADDR = "ipNetToMediaNetAddress";
    public static final String IPNETTOMEDIA_TABLE_TYPE = "ipNetToMediaType";
    public static SnmpObjId[] ms_elemList = new SnmpObjId[]{IPNETTOMEDIA_TABLE_IFINDEX_OID, IPNETTOMEDIA_TABLE_PHYSADDR_OID, IPNETTOMEDIA_TABLE_NETADDR_OID, IPNETTOMEDIA_TABLE_TYPE_OID};

    public IpNetToMediaTableTracker() {
        super(ms_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IpNetToMediaRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIpNetToMediaRow((IpNetToMediaRow)row);
    }

    public void processIpNetToMediaRow(IpNetToMediaRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(IPNETTOMEDIA_TABLE_IFINDEX_OID) + "." + row.getInstance().toString(), IPNETTOMEDIA_TABLE_IFINDEX, row.getIpNetToMediaIfIndex());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(IPNETTOMEDIA_TABLE_PHYSADDR_OID) + "." + row.getInstance().toString(), IPNETTOMEDIA_TABLE_PHYSADDR, row.getIpNetToMediaPhysAddress());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(IPNETTOMEDIA_TABLE_NETADDR_OID) + "." + row.getInstance().toString(), IPNETTOMEDIA_TABLE_NETADDR, InetAddressUtils.str((InetAddress)row.getIpNetToMediaNetAddress()));
        System.out.printf("\t\t%s (%s)= %s (%s)\n", String.valueOf(IPNETTOMEDIA_TABLE_TYPE_OID) + "." + row.getInstance().toString(), IPNETTOMEDIA_TABLE_TYPE, row.getIpNetToMediatype(), IpNetToMedia.IpNetToMediaType.get((Integer)row.getIpNetToMediatype()));
    }

    public static class IpNetToMediaRow
    extends SnmpRowResult {
        public IpNetToMediaRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public String getIpNetToMediaPhysAddress() {
            SnmpValue mac = this.getValue(IPNETTOMEDIA_TABLE_PHYSADDR_OID);
            if (mac == null) {
                return null;
            }
            String hexString = mac.toHexString();
            LOG.debug("getIpNetToMediaPhysAddress: checking as hexString {}", (Object)hexString);
            if (InetAddressUtils.isValidBridgeAddress((String)hexString)) {
                return hexString;
            }
            try {
                if (mac.isDisplayable()) {
                    String displayString = mac.toDisplayString();
                    return displayString == null || displayString.trim().isEmpty() ? null : InetAddressUtils.normalizeMacAddress((String)displayString);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("getIpNetToMediaPhysAddress: IllegalArgument mac on ipnettomediatable:  return null", (Throwable)e);
                return null;
            }
            if (hexString != null && !hexString.trim().isEmpty() && InetAddressUtils.isValidBridgeAddress((String)hexString)) {
                return hexString;
            }
            LOG.warn("getIpNetToMediaPhysAddress: not valid mac {}, return null", (Object)hexString);
            return null;
        }

        public InetAddress getIpNetToMediaNetAddress() {
            SnmpValue value = this.getValue(IPNETTOMEDIA_TABLE_NETADDR_OID);
            if (value == null) {
                return null;
            }
            return value.toInetAddress();
        }

        public Integer getIpNetToMediatype() {
            SnmpValue value = this.getValue(IPNETTOMEDIA_TABLE_TYPE_OID);
            if (value == null) {
                return null;
            }
            return value.toInt();
        }

        public Integer getIpNetToMediaIfIndex() {
            SnmpValue value = this.getValue(IPNETTOMEDIA_TABLE_IFINDEX_OID);
            if (value == null) {
                return null;
            }
            return value.toInt();
        }

        public IpNetToMedia getIpNetToMedia() {
            IpNetToMedia at = new IpNetToMedia();
            at.setSourceIfIndex(this.getIpNetToMediaIfIndex());
            at.setPhysAddress(this.getIpNetToMediaPhysAddress());
            at.setNetAddress(this.getIpNetToMediaNetAddress());
            at.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.get((Integer)this.getIpNetToMediatype()));
            return at;
        }
    }
}

