/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;

public final class DataSourceConfigurationFactory {
    private final DataSourceConfiguration m_dsc;

    public DataSourceConfigurationFactory(File fileName) {
        try {
            this.m_dsc = (DataSourceConfiguration)JaxbUtils.unmarshal(DataSourceConfiguration.class, (File)fileName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not unmarshal " + DataSourceConfiguration.class.getName(), e);
        }
    }

    public DataSourceConfigurationFactory(String fileName) {
        this(new File(fileName));
    }

    public DataSourceConfigurationFactory(InputStream fileInputStream) {
        try (InputStreamReader reader = new InputStreamReader(fileInputStream);){
            this.m_dsc = (DataSourceConfiguration)JaxbUtils.unmarshal(DataSourceConfiguration.class, (Reader)reader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not unmarshal " + DataSourceConfiguration.class.getName(), e);
        }
    }

    public ConnectionPool getConnectionPool() {
        return this.m_dsc.getConnectionPool();
    }

    public JdbcDataSource getJdbcDataSource(String name) {
        for (JdbcDataSource ds : this.m_dsc.getJdbcDataSource()) {
            if (!ds.getName().equals(name)) continue;
            return ds;
        }
        return null;
    }
}

