/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.vmware.internal;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleSearchProvider;
import org.opennms.features.topology.plugins.topo.vmware.internal.VmwareTopologyProvider;

public class VmwareTopologySearchProvider
extends SimpleSearchProvider {
    private VmwareTopologyProvider vmwareTopologyProvider;

    public VmwareTopologySearchProvider(VmwareTopologyProvider vmwareTopologyProvider) {
        this.vmwareTopologyProvider = Objects.requireNonNull(vmwareTopologyProvider);
    }

    public String getSearchProviderNamespace() {
        return "vmware";
    }

    public List<? extends VertexRef> queryVertices(SearchQuery searchQuery, GraphContainer container) {
        List vertices = this.vmwareTopologyProvider.getCurrentGraph().getVertices(new Criteria[0]);
        return vertices.stream().filter(v -> searchQuery.matches(v.getLabel())).collect(Collectors.toList());
    }
}

