/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsUserNotification;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.AcknowledgeType;
import org.opennms.web.notification.NoticeSentTo;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.SortStyle;
import org.opennms.web.notification.WebNotificationRepository;
import org.opennms.web.notification.filter.NotificationCriteria;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DaoWebNotificationRepository
implements WebNotificationRepository,
InitializingBean {
    @Autowired
    NotificationDao m_notificationDao;
    @Autowired
    AcknowledgmentDao m_ackDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    private static final OnmsCriteria getOnmsCriteria(NotificationCriteria notificationCriteria) {
        final OnmsCriteria criteria = new OnmsCriteria(OnmsNotification.class);
        criteria.createAlias("node", "node", 1);
        criteria.createAlias("serviceType", "serviceType", 1);
        criteria.createAlias("event", "event", 1);
        criteria.createAlias("event.distPoller", "distPoller", 1);
        notificationCriteria.visit(new NotificationCriteria.NotificationCriteriaVisitor<RuntimeException>(){

            @Override
            public void visitAckType(AcknowledgeType ackType) throws RuntimeException {
                if (ackType == AcknowledgeType.ACKNOWLEDGED) {
                    criteria.add(Restrictions.isNotNull((String)"answeredBy"));
                } else if (ackType == AcknowledgeType.UNACKNOWLEDGED) {
                    criteria.add(Restrictions.isNull((String)"answeredBy"));
                }
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                criteria.add(filter.getCriterion());
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                criteria.setMaxResults(Integer.valueOf(limit));
                criteria.setFirstResult(Integer.valueOf(offset));
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                switch (sortStyle) {
                    case LOCATION: {
                        criteria.addOrder(Order.desc((String)"event.distPoller.location"));
                        break;
                    }
                    case RESPONDER: {
                        criteria.addOrder(Order.desc((String)"answeredBy"));
                        break;
                    }
                    case PAGETIME: {
                        criteria.addOrder(Order.desc((String)"pageTime"));
                        break;
                    }
                    case RESPONDTIME: {
                        criteria.addOrder(Order.desc((String)"respondTime"));
                        break;
                    }
                    case NODE: {
                        criteria.addOrder(Order.desc((String)"node.label"));
                        break;
                    }
                    case NODE_LOCATION: {
                        criteria.addOrder(Order.desc((String)"node.location.locationName"));
                        break;
                    }
                    case INTERFACE: {
                        criteria.addOrder(Order.desc((String)"ipAddress"));
                        break;
                    }
                    case SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceType.name"));
                        break;
                    }
                    case ID: {
                        criteria.addOrder(Order.desc((String)"notifyId"));
                        break;
                    }
                    case SEVERITY: {
                        criteria.addOrder(Order.desc((String)"event.eventSeverity"));
                        break;
                    }
                    case REVERSE_LOCATION: {
                        criteria.addOrder(Order.desc((String)"event.distPoller.location"));
                        break;
                    }
                    case REVERSE_RESPONDER: {
                        criteria.addOrder(Order.asc((String)"answeredBy"));
                        break;
                    }
                    case REVERSE_PAGETIME: {
                        criteria.addOrder(Order.asc((String)"pageTime"));
                        break;
                    }
                    case REVERSE_RESPONDTIME: {
                        criteria.addOrder(Order.asc((String)"respondTime"));
                        break;
                    }
                    case REVERSE_NODE: {
                        criteria.addOrder(Order.asc((String)"node.label"));
                        break;
                    }
                    case REVERSE_NODE_LOCATION: {
                        criteria.addOrder(Order.asc((String)"node.location.locationName"));
                        break;
                    }
                    case REVERSE_INTERFACE: {
                        criteria.addOrder(Order.asc((String)"ipAddress"));
                        break;
                    }
                    case REVERSE_SERVICE: {
                        criteria.addOrder(Order.asc((String)"serviceType.name"));
                        break;
                    }
                    case REVERSE_ID: {
                        criteria.addOrder(Order.asc((String)"notifyId"));
                        break;
                    }
                    case REVERSE_SEVERITY: {
                        criteria.addOrder(Order.asc((String)"event.eventSeverity"));
                    }
                }
            }
        });
        return criteria;
    }

    private static Notification mapOnmsNotificationToNotification(OnmsNotification onmsNotification) {
        if (onmsNotification != null) {
            Notification notif = new Notification();
            notif.m_eventId = onmsNotification.getEvent() != null ? onmsNotification.getEvent().getId() : 0L;
            notif.m_interfaceID = onmsNotification.getIpAddress() == null ? null : InetAddressUtils.toIpAddrString((InetAddress)onmsNotification.getIpAddress());
            notif.m_nodeID = onmsNotification.getNode() != null ? onmsNotification.getNode().getId() : 0;
            notif.m_notifyID = onmsNotification.getNotifyId();
            notif.m_numMsg = onmsNotification.getNumericMsg();
            notif.m_responder = onmsNotification.getAnsweredBy();
            notif.m_serviceId = onmsNotification.getServiceType() != null ? onmsNotification.getServiceType().getId() : 0;
            notif.m_serviceName = onmsNotification.getServiceType() != null ? onmsNotification.getServiceType().getName() : "";
            notif.m_timeReply = onmsNotification.getRespondTime() != null ? onmsNotification.getRespondTime().getTime() : 0L;
            notif.m_timeSent = onmsNotification.getPageTime() != null ? onmsNotification.getPageTime().getTime() : 0L;
            notif.m_txtMsg = onmsNotification.getTextMsg();
            ArrayList<NoticeSentTo> sentToList = new ArrayList<NoticeSentTo>();
            for (OnmsUserNotification userNotified : onmsNotification.getUsersNotified()) {
                NoticeSentTo newSentTo = new NoticeSentTo();
                newSentTo.setUserId(userNotified.getUserId());
                if (userNotified.getNotifyTime() == null) {
                    newSentTo.setTime(0L);
                } else {
                    newSentTo.setTime(userNotified.getNotifyTime().getTime());
                }
                newSentTo.setMedia(userNotified.getMedia());
                newSentTo.setContactInfo(userNotified.getContactInfo());
                sentToList.add(newSentTo);
            }
            notif.m_sentTo = sentToList;
            return notif;
        }
        return null;
    }

    @Override
    @Transactional
    public void acknowledgeMatchingNotification(String user, Date timestamp, NotificationCriteria criteria) {
        List notifs = this.m_notificationDao.findMatching(DaoWebNotificationRepository.getOnmsCriteria(criteria));
        for (OnmsNotification notif : notifs) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)notif, user);
            ack.setAckAction(AckAction.ACKNOWLEDGE);
            ack.setAckTime(timestamp);
            this.m_ackDao.processAck(ack);
        }
    }

    @Override
    @Transactional
    public int countMatchingNotifications(NotificationCriteria criteria) {
        return this.m_notificationDao.countMatching(DaoWebNotificationRepository.getOnmsCriteria(criteria));
    }

    @Override
    @Transactional
    public Notification[] getMatchingNotifications(NotificationCriteria criteria) {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        List onmsNotifs = this.m_notificationDao.findMatching(DaoWebNotificationRepository.getOnmsCriteria(criteria));
        for (OnmsNotification notif : onmsNotifs) {
            notifications.add(DaoWebNotificationRepository.mapOnmsNotificationToNotification(notif));
        }
        return notifications.toArray(new Notification[0]);
    }

    @Override
    @Transactional
    public Notification getNotification(int noticeId) {
        return DaoWebNotificationRepository.mapOnmsNotificationToNotification((OnmsNotification)this.m_notificationDao.get((Serializable)Integer.valueOf(noticeId)));
    }
}

