/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

public abstract class NotEqualsFilterNullAware
extends OneArgFilter<String> {
    public NotEqualsFilterNullAware(String filterType, SQLType<String> type, String fieldName, String daoPropertyName, String value) {
        super(filterType, type, fieldName, daoPropertyName, NotEqualsFilterNullAware.toValueAllowNull(value));
    }

    private static String toValueAllowNull(String value) {
        return "null".equals(value) ? null : value;
    }

    @Override
    public Criterion getCriterion() {
        if (this.getValue() == null) {
            return Restrictions.isNotNull((String)this.getPropertyName());
        }
        return Restrictions.or((Criterion)Restrictions.ne((String)this.getPropertyName(), this.getValue()), (Criterion)Restrictions.isNull((String)this.getPropertyName()));
    }

    @Override
    public String getSQLTemplate() {
        if (this.getValue() == null) {
            return " " + this.getSQLFieldName() + " IS NOT NULL ";
        }
        return " " + this.getSQLFieldName() + " <> %s OR IS NULL";
    }
}

