/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.element.ElementIdNotFoundException;
import org.opennms.web.element.ElementNotFoundException;
import org.opennms.web.element.Interface;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.Service;
import org.opennms.web.element.ServiceNameComparator;
import org.opennms.web.servlet.MissingParameterException;
import org.springframework.util.Assert;

public abstract class ElementUtil {
    private static final EnumMap<OnmsNode.NodeType, String> m_nodeStatusMap = new EnumMap(OnmsNode.NodeType.class);
    private static final Map<Character, String> m_interfaceStatusMap;
    private static final Map<Character, String> m_interfaceSnmpStatusMap;
    private static final Map<Character, String> m_serviceStatusMap;
    static final String[] IFTYPES;
    static final String[] OPER_ADMIN_STATUS;
    static final String[] IP_ROUTE_TYPE;
    static final String[] IP_ROUTE_PROTO;
    public static final int DEFAULT_TRUNCATE_THRESHOLD = 28;

    public static String getIpRouteProtocolString(int iprouteprotocol) {
        if (IP_ROUTE_PROTO.length > iprouteprotocol) {
            return IP_ROUTE_PROTO[iprouteprotocol];
        }
        return IP_ROUTE_PROTO[0];
    }

    public static String getIpRouteTypeString(int iproutetype) {
        if (IP_ROUTE_TYPE.length > iproutetype) {
            return IP_ROUTE_TYPE[iproutetype];
        }
        return IP_ROUTE_TYPE[0];
    }

    public static String getIfStatusString(int ifStatusNum) {
        if (ifStatusNum < OPER_ADMIN_STATUS.length) {
            return OPER_ADMIN_STATUS[ifStatusNum];
        }
        return "Unknown (" + ifStatusNum + ")";
    }

    public static String getIfTypeString(int ifTypeNum) {
        if (ifTypeNum < IFTYPES.length) {
            return IFTYPES[ifTypeNum];
        }
        return "Unknown (" + ifTypeNum + ")";
    }

    public static String getNodeStatusString(OnmsNode node) {
        Assert.notNull((Object)node, (String)"node argument cannot be null");
        return ElementUtil.getNodeStatusString(node.getType());
    }

    public static String getNodeStatusString(OnmsNode.NodeType c) {
        return m_nodeStatusMap.get(c);
    }

    public static String getInterfaceStatusString(Interface intf) {
        Assert.notNull((Object)intf, (String)"intf argument cannot be null");
        return ElementUtil.getInterfaceStatusString(intf.isManagedChar());
    }

    public static String getInterfaceStatusString(char c) {
        return m_interfaceStatusMap.get(Character.valueOf(c));
    }

    public static String getSnmpInterfaceStatusString(Interface intf) {
        Assert.notNull((Object)intf, (String)"intf argument cannot be null");
        return ElementUtil.getSnmpInterfaceStatusString(intf.isSnmpPollChar());
    }

    public static String getSnmpInterfaceStatusString(char c) {
        return m_interfaceSnmpStatusMap.get(Character.valueOf(c));
    }

    public static String getServiceStatusString(Service svc) {
        Assert.notNull((Object)svc, (String)"svc argument cannot be null");
        return ElementUtil.getServiceStatusString(svc.getStatus());
    }

    public static String getServiceStatusString(char c) {
        return m_serviceStatusMap.get(Character.valueOf(c));
    }

    public static boolean hasLocallyMonitoredServices(Service[] svcs) {
        for (Service svc : svcs) {
            char status = svc.getStatus();
            if (status == 'X') continue;
            return true;
        }
        return false;
    }

    public static String truncateLabel(String label) {
        return ElementUtil.truncateLabel(label, 28);
    }

    public static String truncateLabel(String label, int truncateThreshold) {
        Assert.notNull((Object)label, (String)"label argument cannot be null");
        Assert.isTrue((truncateThreshold >= 3 ? 1 : 0) != 0, (String)("Cannot take a truncate position less than 3 (truncateThreshold is " + truncateThreshold + ")"));
        Object shortLabel = label;
        if (label.length() > truncateThreshold) {
            shortLabel = label.substring(0, truncateThreshold - 3) + "...";
        }
        return shortLabel;
    }

    public static OnmsNode getNodeByParams(HttpServletRequest request, ServletContext servletContext) throws ServletException, SQLException {
        return ElementUtil.getNodeByParams(request, "node", servletContext);
    }

    public static OnmsNode getNodeByParams(HttpServletRequest request, String nodeLookupParam, ServletContext servletContext) throws ServletException, SQLException {
        OnmsNode node;
        if (request.getParameter(nodeLookupParam) == null) {
            throw new MissingParameterException(nodeLookupParam, new String[]{"node"});
        }
        String nodeLookupString = request.getParameter(nodeLookupParam);
        if (!nodeLookupString.contains(":")) {
            try {
                Integer.parseInt(nodeLookupString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + nodeLookupString + "\", should be integer", nodeLookupString, "node", "element/node.jsp", "node", "element/nodeList.htm");
            }
        }
        if ((node = NetworkElementFactory.getInstance(servletContext).getNode(nodeLookupString)) == null) {
            throw new ElementNotFoundException("No such node in database", "node", "element/node.jsp", "node", "element/nodeList.htm");
        }
        return node;
    }

    public static Interface getInterfaceByParams(HttpServletRequest request, ServletContext servletContext) throws ServletException, SQLException {
        return ElementUtil.getInterfaceByParams(request, "ipinterfaceid", "node", "intf", servletContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Interface getInterfaceByParams(HttpServletRequest request, String ipInterfaceIdParam, String nodeIdParam, String ipAddrParam, ServletContext servletContext) throws ServletException, SQLException {
        Interface intf;
        if (request.getParameter(ipInterfaceIdParam) != null) {
            int ipInterfaceId;
            String ifServiceIdString = request.getParameter(ipInterfaceIdParam);
            try {
                ipInterfaceId = Integer.parseInt(ifServiceIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + ipInterfaceIdParam + "\", should be integer", ifServiceIdString, "service");
            }
            intf = NetworkElementFactory.getInstance(servletContext).getInterface(ipInterfaceId);
            if (intf != null && intf.getIfIndex() <= 0) {
                intf.m_ifIndex = NetworkElementFactory.getInstance(servletContext).getIfIndex(ipInterfaceId);
            }
        } else {
            int nodeId;
            String nodeIdString = request.getParameter(nodeIdParam);
            String ipAddr = request.getParameter(ipAddrParam);
            String[] requiredParameters = new String[]{nodeIdParam, ipAddrParam};
            if (nodeIdString == null) {
                throw new MissingParameterException(nodeIdParam, requiredParameters);
            }
            if (ipAddr == null) {
                throw new MissingParameterException(ipAddrParam, requiredParameters);
            }
            if (nodeIdString.contains(":")) {
                OnmsNode node = NetworkElementFactory.getInstance(servletContext).getNode(nodeIdString);
                if (node == null) throw new ElementNotFoundException("No such node in database", "node", "element/node.jsp", "node", "element/nodeList.htm");
                nodeId = node.getId();
            } else {
                try {
                    nodeId = Integer.parseInt(nodeIdString);
                }
                catch (NumberFormatException e) {
                    throw new ElementIdNotFoundException("Wrong data type for \"" + nodeIdParam + "\", should be integer", nodeIdString, "node");
                }
            }
            intf = NetworkElementFactory.getInstance(servletContext).getInterface(nodeId, ipAddr);
            if (intf != null && intf.getIfIndex() <= 0) {
                intf.m_ifIndex = NetworkElementFactory.getInstance(servletContext).getIfIndex(nodeId, ipAddr);
            }
        }
        if (intf != null) return intf;
        throw new ElementNotFoundException("No such interface in database", "interface", "element/interface.jsp", "ipinterfaceid", "element/interface.jsp");
    }

    public static Interface getSnmpInterfaceByParams(HttpServletRequest request, ServletContext servletContext) throws ServletException, SQLException {
        return ElementUtil.getSnmpInterfaceByParams(request, "node", "ifindex", servletContext);
    }

    public static Interface getSnmpInterfaceByParams(HttpServletRequest request, String nodeIdParam, String ifIndexParam, ServletContext servletContext) throws ServletException, SQLException {
        int ifIndex;
        int nodeId;
        String nodeIdString = request.getParameter(nodeIdParam);
        String ifIndexString = request.getParameter(ifIndexParam);
        String[] requiredParameters = new String[]{nodeIdParam, ifIndexParam};
        if (nodeIdString == null) {
            throw new MissingParameterException(nodeIdParam, requiredParameters);
        }
        if (ifIndexString == null) {
            throw new MissingParameterException(ifIndexParam, requiredParameters);
        }
        try {
            nodeId = Integer.parseInt(nodeIdString);
        }
        catch (NumberFormatException e) {
            throw new ElementIdNotFoundException("Wrong data type for \"" + nodeIdParam + "\", should be integer", nodeIdString, "node");
        }
        try {
            ifIndex = Integer.parseInt(ifIndexString);
        }
        catch (NumberFormatException e) {
            throw new ElementIdNotFoundException("Wrong data type for \"" + ifIndexParam + "\", should be integer", ifIndexString, "interface");
        }
        Interface intf = NetworkElementFactory.getInstance(servletContext).getSnmpInterface(nodeId, ifIndex);
        if (intf == null) {
            throw new ElementNotFoundException("No such SNMP interface in database for nodeId " + nodeIdString + " ifIndex " + ifIndexString, "snmpinterface");
        }
        return intf;
    }

    public static Service getServiceByParams(HttpServletRequest request, ServletContext servletContext) throws ServletException, SQLException {
        return ElementUtil.getServiceByParams(request, "ifserviceid", "node", "intf", "service", servletContext);
    }

    public static Service getServiceByParams(HttpServletRequest request, String ifServiceIdParam, String nodeIdParam, String ipAddrParam, String serviceIdParam, ServletContext servletContext) throws ServletException, SQLException {
        Service service;
        if (request.getParameter(ifServiceIdParam) != null) {
            int ifServiceId;
            String ifServiceIdString = request.getParameter(ifServiceIdParam);
            try {
                ifServiceId = Integer.parseInt(ifServiceIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + ifServiceIdParam + "\", should be integer", ifServiceIdString, "service");
            }
            service = NetworkElementFactory.getInstance(servletContext).getService(ifServiceId);
        } else {
            int serviceId;
            int nodeId;
            String nodeIdString = request.getParameter(nodeIdParam);
            String ipAddr = request.getParameter(ipAddrParam);
            String serviceIdString = request.getParameter(serviceIdParam);
            String[] requiredParameters = new String[]{nodeIdParam, ipAddrParam, serviceIdParam};
            if (nodeIdString == null) {
                throw new MissingParameterException(nodeIdParam, requiredParameters);
            }
            if (ipAddr == null) {
                throw new MissingParameterException(ipAddrParam, requiredParameters);
            }
            if (serviceIdString == null) {
                throw new MissingParameterException(serviceIdParam, requiredParameters);
            }
            try {
                nodeId = Integer.parseInt(nodeIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + nodeIdParam + "\", should be integer", nodeIdString, "node");
            }
            try {
                serviceId = Integer.parseInt(serviceIdString);
            }
            catch (NumberFormatException e) {
                throw new ElementIdNotFoundException("Wrong data type for \"" + serviceIdParam + "\", should be integer", serviceIdString, "service");
            }
            service = NetworkElementFactory.getInstance(servletContext).getService(nodeId, ipAddr, serviceId);
        }
        if (service == null) {
            String ipAddr = request.getParameter(ipAddrParam);
            String serviceIdString = request.getParameter(serviceIdParam);
            throw new ElementNotFoundException("No such service in database for " + ipAddr + " with service ID " + serviceIdString, "service");
        }
        return service;
    }

    public static Service[] getServicesOnNodeByParams(HttpServletRequest request, int serviceId, ServletContext servletContext) throws SQLException {
        int nodeId;
        try {
            nodeId = Integer.parseInt(request.getParameter("node"));
        }
        catch (NumberFormatException nfe) {
            throw new ElementIdNotFoundException("Wrong type for parameter \"node\" (should be integer)", request.getParameter("node"), "node", "element/node.jsp", "node", "element/nodeList.jsp");
        }
        Service[] services = NetworkElementFactory.getInstance(servletContext).getServicesOnNode(nodeId, serviceId);
        return services;
    }

    public static Service[] getServicesOnInterface(int nodeId, String ipAddr, ServletContext servletContext) throws SQLException {
        ServiceNameComparator m_serviceComparator = new ServiceNameComparator();
        Service[] svcs = NetworkElementFactory.getInstance(servletContext).getServicesOnInterface(nodeId, ipAddr);
        if (svcs != null) {
            Arrays.sort(svcs, m_serviceComparator);
        }
        return svcs;
    }

    static {
        m_nodeStatusMap.put(OnmsNode.NodeType.ACTIVE, "Active");
        m_nodeStatusMap.put(OnmsNode.NodeType.UNKNOWN, "Unknown");
        m_nodeStatusMap.put(OnmsNode.NodeType.DELETED, "Deleted");
        m_interfaceStatusMap = new HashMap<Character, String>();
        m_interfaceStatusMap.put(Character.valueOf('M'), "Managed");
        m_interfaceStatusMap.put(Character.valueOf('U'), "Unmanaged");
        m_interfaceStatusMap.put(Character.valueOf('D'), "Deleted");
        m_interfaceStatusMap.put(Character.valueOf('F'), "Forced Unmanaged");
        m_interfaceStatusMap.put(Character.valueOf('N'), "Not Monitored");
        m_interfaceSnmpStatusMap = new HashMap<Character, String>();
        m_interfaceSnmpStatusMap.put(Character.valueOf('P'), "Polled");
        m_interfaceSnmpStatusMap.put(Character.valueOf('I'), "Not Polled");
        m_interfaceSnmpStatusMap.put(Character.valueOf('N'), "Not Monitored");
        m_serviceStatusMap = new HashMap<Character, String>();
        m_serviceStatusMap.put(Character.valueOf('A'), "Managed");
        m_serviceStatusMap.put(Character.valueOf('U'), "Unmanaged");
        m_serviceStatusMap.put(Character.valueOf('D'), "Deleted");
        m_serviceStatusMap.put(Character.valueOf('F'), "Forced Unmanaged");
        m_serviceStatusMap.put(Character.valueOf('N'), "Not Monitored");
        m_serviceStatusMap.put(Character.valueOf('R'), "Rescan to Resume");
        m_serviceStatusMap.put(Character.valueOf('S'), "Rescan to Suspend");
        m_serviceStatusMap.put(Character.valueOf('X'), "Remotely Monitored");
        IFTYPES = new String[]{"&nbsp;", "other", "regular1822", "hdh1822", "ddn-x25", "rfc877-x25", "ethernetCsmacd", "iso88023Csmacd", "iso88024TokenBus", "iso88025TokenRing", "iso88026Man", "starLan", "proteon-10Mbit", "proteon-80Mbit", "hyperchannel", "fddi", "lapb", "sdlc", "ds1", "e1", "basicISDN", "primaryISDN", "propPointToPointSerial", "ppp", "softwareLoopback", "eon", "ethernet-3Mbit", "nsip", "slip", "ultra", "ds3", "sip", "frame-relay", "rs232", "para", "arcnet", "arcnetPlus", "atm", "miox25", "sonet", "x25ple", "is0880211c", "localTalk", "smdsDxi", "frameRelayService", "v35", "hssi", "hippi", "modem", "aa15", "sonetPath", "sonetVT", "smdsIcip", "propVirtual", "propMultiplexor", "ieee80212", "fibreChannel", "hippiInterface", "frameRelayInterconnect", "aflane8023", "aflane8025", "cctEmul", "fastEther", "isdn", "v11", "v36", "g703at64k", "g703at2mb", "qllc", "fastEtherFX", "channel", "ieee80211", "ibm370parChan", "escon", "dlsw", "isdns", "isdnu", "lapd", "ipSwitch", "rsrb", "atmLogical", "ds0", "ds0Bundle", "bsc", "async", "cnr", "iso88025Dtr", "eplrs", "arap", "propCnls", "hostPad", "termPad", "frameRelayMPI", "x213", "adsl", "radsl", "sdsl", "vdsl", "iso88025CRFPInt", "myrinet", "voiceEM", "voiceFXO", "voiceFXS", "voiceEncap", "voiceOverIp", "atmDxi", "atmFuni", "atmIma", "pppMultilinkBundle", "ipOverCdlc", "ipOverClaw", "stackToStack", "virtualIpAddress", "mpc", "ipOverAtm", "iso88025Fiber", "tdlc", "gigabitEthernet", "hdlc", "lapf", "v37", "x25mlp", "x25huntGroup", "trasnpHdlc", "interleave", "fast", "ip", "docsCableMaclayer", "docsCableDownstream", "docsCableUpstream", "a12MppSwitch", "tunnel", "coffee", "ces", "atmSubInterface", "l2vlan", "l3ipvlan", "l3ipxvlan", "digitalPowerline", "mediaMailOverIp", "dtm", "dcn", "ipForward", "msdsl", "ieee1394", "if-gsn", "dvbRccMacLayer", "dvbRccDownstream", "dvbRccUpstream", "atmVirtual", "mplsTunnel", "srp", "voiceOverAtm", "voiceOverFrameRelay", "idsl", "compositeLink", "ss7SigLink", "propWirelessP2P", "frForward", "rfc1483", "usb", "ieee8023adLag", "bgppolicyaccounting", "frf16MfrBundle", "h323Gatekeeper", "h323Proxy", "mpls", "mfSigLink", "hdsl2", "shdsl", "ds1FDL", "pos", "dvbAsiIn", "dvbAsiOut", "plc", "nfas", "tr008", "gr303RDT", "gr303IDT", "isup", "propDocsWirelessMaclayer", "propDocsWirelessDownstream", "propDocsWirelessUpstream", "hiperlan2", "propBWAp2Mp", "sonetOverheadChannel", "digitalWrapperOverheadChannel", "aal2", "radioMAC", "atmRadio", "imt", "mvl", "reachDSL", "frDlciEndPt", "atmVciEndPt", "opticalChannel", "opticalTransport", "propAtm", "voiceOverCable", "infiniband", "teLink", "q2931", "virtualTg", "sipTg", "sipSig", "docsCableUpstreamChannel", "econet", "pon155", "pon622", "bridge", "linegroup", "voiceEMFGD", "voiceFGDEANA", "voiceDID", "mpegTransport", "sixToFour", "gtp", "pdnEtherLoop1", "pdnEtherLoop2", "opticalChannelGroup", "homepna", "gfp", "ciscoISLvlan", "actelisMetaLOOP", "fcipLink", "rpr", "qam", "lmp", "cblVectaStar", "docsCableMCmtsDownstream", "adsl2", "macSecControlledIF", "macSecUncontrolledIF", "aviciOpticalEther", "atmbond", "voiceFGDOS", "mocaVersion1", "ieee80216WMAN", "adsl2plus", "dvbRcsMacLayer", "dvbTdm", "dvbRcsTdma", "x86Laps", "wwanPP", "wwanPP2", "voiceEBS", "ifPwType", "ilan", "pip", "aluELP", "gpon"};
        OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
        IP_ROUTE_TYPE = new String[]{"&nbsp;", "Other", "Invalid", "Direct", "Indirect"};
        IP_ROUTE_PROTO = new String[]{"&nbsp;", "Other", "Local", "Netmgmt", "icmp", "egp", "ggp", "hello", "rip", "is-is", "es-is", "CiscoIGRP", "bbnSpfIgp", "ospf", "bgp"};
    }
}

