/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.application;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsSeverity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ApplicationBoxController
extends AbstractController
implements InitializingBean {
    public static final int DEFAULT_ROW_COUNT = 10;
    private ApplicationDao applicationDao;
    private String m_successView;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean more;
        int numberOfRows = SystemProperties.getInteger((String)"opennms.applicationsWithProblems.count", (int)10);
        boolean all = "true".equalsIgnoreCase(request.getParameter("all"));
        List applicationStatus = this.applicationDao.getApplicationStatus();
        applicationStatus = applicationStatus.stream().filter(a -> a.getSeverity().isGreaterThan(OnmsSeverity.NORMAL)).collect(Collectors.toList());
        boolean bl = more = !all && applicationStatus.size() - numberOfRows > 0;
        if (!all && applicationStatus.size() > numberOfRows) {
            applicationStatus = applicationStatus.subList(0, numberOfRows);
        }
        applicationStatus.sort((s1, s2) -> -1 * s1.getSeverity().compareTo((Enum)s2.getSeverity()));
        ModelAndView modelAndView = new ModelAndView(this.m_successView);
        modelAndView.addObject("more", (Object)more);
        modelAndView.addObject("summaries", applicationStatus);
        return modelAndView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.applicationDao = applicationDao;
    }

    public void afterPropertiesSet() {
        Objects.requireNonNull(this.m_successView, "successView must be set");
        Objects.requireNonNull(this.applicationDao, "applicationDao must be set");
    }

    public static class ApplicationSummary {
        private OnmsApplication application;
        private OnmsSeverity severity;

        public ApplicationSummary(OnmsApplication application, OnmsSeverity severity) {
            this.application = application;
            this.severity = severity;
        }

        public OnmsApplication getApplication() {
            return this.application;
        }

        public OnmsSeverity getSeverity() {
            return this.severity;
        }
    }
}

