/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.web.alarm.AlarmIdNotFoundException;
import org.opennms.web.controller.alarm.RelatedEvent;
import org.opennms.web.event.Event;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.AlarmIDFilter;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.filter.Filter;
import org.opennms.web.servlet.XssRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.view.RedirectView;

public class AlarmDetailController
extends MultiActionController {
    private static final int DEFAULT_SHORT_LIMIT = 20;
    private static final int DEFAULT_MULTIPLE = 0;
    private static final Logger logger = LoggerFactory.getLogger(AlarmDetailController.class);
    private AlarmRepository m_webAlarmRepository;
    private WebEventRepository m_webEventRepository;
    private Integer m_defaultShortLimit = 20;

    public void setAlarmRepository(AlarmRepository repository) {
        this.m_webAlarmRepository = repository;
    }

    public void setWebEventRepository(WebEventRepository repository) {
        this.m_webEventRepository = repository;
    }

    public void setDefaultShortLimit(Integer limit) {
        this.m_defaultShortLimit = limit;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
        Assert.notNull((Object)this.m_webEventRepository, (String)"webEventRepository must be set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug("AlarmDetailController handleRequestInternal called");
        return super.handleRequestInternal(request, response);
    }

    public ModelAndView detail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        OnmsAlarm alarm = null;
        XssRequestWrapper safeRequest = new XssRequestWrapper(httpServletRequest);
        String alarmIdString = "";
        List acknowledgments = Collections.emptyList();
        try {
            alarmIdString = safeRequest.getParameter("id");
            int alarmId = Integer.parseInt(alarmIdString);
            acknowledgments = this.m_webAlarmRepository.getAcknowledgments(alarmId);
            alarm = this.m_webAlarmRepository.getAlarm(alarmId);
            logger.debug("Alarm retrieved: '{}'", (Object)alarm.toString());
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse alarm ID '{}' to integer.", (Object)safeRequest.getParameter("id"));
        }
        catch (Throwable e) {
            logger.error("Could not retrieve alarm from webAlarmRepository for ID='{}'", (Object)alarmIdString);
        }
        if (alarm == null) {
            throw new AlarmIdNotFoundException("Could not find alarm with ID: " + alarmIdString, alarmIdString);
        }
        ModelAndView mv = new ModelAndView("alarm/detail");
        mv.addObject("alarm", (Object)alarm);
        mv.addObject("alarmId", (Object)alarmIdString);
        mv.addObject("acknowledgments", (Object)acknowledgments);
        mv.addObject("related", this.getRelatedEvents(alarm, httpServletRequest));
        return mv;
    }

    private void checkRole(HttpServletRequest httpServletRequest) throws ServletException {
        Authentication authentication = (Authentication)httpServletRequest.getUserPrincipal();
        boolean isAdmin = authentication.getAuthorities().stream().anyMatch(g -> Objects.equals("ROLE_ADMIN", g.getAuthority()));
        boolean isReadOnly = authentication.getAuthorities().stream().anyMatch(g -> Objects.equals("ROLE_READONLY", g.getAuthority()));
        if (!isAdmin && isReadOnly) {
            throw new ServletException("User '" + authentication.getName() + "', is a read-only user!");
        }
    }

    public ModelAndView removeStickyMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        this.checkRole(httpServletRequest);
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            this.m_webAlarmRepository.removeStickyMemo(Integer.valueOf(alarmId));
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView saveStickyMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        this.checkRole(httpServletRequest);
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            String stickyMemoBody = httpServletRequest.getParameter("stickyMemoBody");
            this.m_webAlarmRepository.updateStickyMemo(Integer.valueOf(alarmId), stickyMemoBody, httpServletRequest.getRemoteUser());
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView removeJournalMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        this.checkRole(httpServletRequest);
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            this.m_webAlarmRepository.removeReductionKeyMemo(alarmId);
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView saveJournalMemo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        this.checkRole(httpServletRequest);
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            String journalMemoBody = httpServletRequest.getParameter("journalMemoBody");
            this.m_webAlarmRepository.updateReductionKeyMemo(Integer.valueOf(alarmId), journalMemoBody, httpServletRequest.getRemoteUser());
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    private List<RelatedEvent> getRelatedEvents(OnmsAlarm alarm, HttpServletRequest request) {
        Assert.notNull((Object)alarm);
        ArrayList<RelatedEvent> relatedEvents = new ArrayList<RelatedEvent>();
        ArrayList<Filter> filters = new ArrayList<Filter>(List.of(new AlarmIDFilter(alarm.getId())));
        SortStyle sortStyle = SortStyle.ID;
        String sortStyleString = request.getParameter("sortby");
        if (sortStyleString != null) {
            try {
                sortStyle = SortStyle.getSortStyle(sortStyleString);
            }
            catch (IllegalArgumentException e) {
                logger.error("Unable to determine SortStyle for '{}'", (Object)sortStyleString, (Object)e);
            }
        }
        int limit = this.m_defaultShortLimit;
        String limitString = request.getParameter("limit");
        if (limitString != null) {
            try {
                int newLimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newLimit > 0) {
                    limit = newLimit;
                }
            }
            catch (NumberFormatException e) {
                logger.error("Unable to parse query limit '{}'", (Object)limitString, (Object)e);
            }
        }
        int multiple = 0;
        String multipleString = request.getParameter("multiple");
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException e) {
                logger.error("Unable to parse query multiple '{}'", (Object)multipleString, (Object)e);
            }
        }
        EventCriteria queryCriteria = new EventCriteria(filters, sortStyle, null, limit, limit * multiple);
        try {
            for (Event event : this.m_webEventRepository.getMatchingEvents(queryCriteria)) {
                relatedEvents.add(new RelatedEvent(event.getId(), event.getAlarmId(), event.getCreateTime(), event.getSeverity(), event.getUei(), event.getLogMessage()));
            }
        }
        catch (Exception e) {
            logger.error("Could not retrieve events for queryCriteria '{}'.", (Object)queryCriteria);
        }
        return relatedEvents;
    }
}

