/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.groups.parsers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.opennms.web.admin.groups.parsers.GroupInfo;

public class Group
implements Cloneable {
    public static final String GROUP_NAME_PROPERTY = "groupName";
    private String m_groupName = "";
    private String m_groupComments = "";
    private GroupInfo m_groupInfo;
    private List<String> m_users;
    private PropertyChangeSupport m_propChange = new PropertyChangeSupport(this);

    public Group() {
        this.m_users = new ArrayList<String>();
        this.m_groupInfo = new GroupInfo();
    }

    public Group clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        Group newGroup = new Group();
        newGroup.setGroupName(this.m_groupName);
        newGroup.setGroupComments(this.m_groupComments);
        for (int i = 0; i < this.m_users.size(); ++i) {
            newGroup.addUser(this.m_users.get(i));
        }
        return newGroup;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propChange.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propChange.removePropertyChangeListener(listener);
    }

    public GroupInfo getGroupInfo() {
        return this.m_groupInfo;
    }

    public void setGroupInfo(GroupInfo someInfo) {
        this.m_groupInfo = someInfo;
    }

    public void setGroupName(String aName) {
        String old = this.m_groupName;
        this.m_groupName = aName;
        this.m_propChange.firePropertyChange(GROUP_NAME_PROPERTY, old, this.m_groupName);
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public void setGroupComments(String someComments) {
        this.m_groupComments = someComments;
    }

    public String getGroupComments() {
        return this.m_groupComments;
    }

    public boolean hasUser(String aUser) {
        return this.m_users.contains(aUser);
    }

    public void addUser(String aUser) {
        this.m_users.add(aUser);
    }

    public void removeUser(String aUser) {
        this.m_users.remove(aUser);
    }

    public void clearUsers() {
        this.m_users.clear();
    }

    public List<String> getUsers() {
        return this.m_users;
    }

    public int getUserCount() {
        return this.m_users.size();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("name     = " + this.m_groupName + "\n");
        buffer.append("comments = " + this.m_groupComments + "\n");
        buffer.append("users:\n");
        for (String user : this.m_users) {
            buffer.append("\t" + user + "\n");
        }
        return buffer.toString();
    }
}

