/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.discovery;

import javax.servlet.http.HttpServletRequest;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralSettingsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralSettingsLoader.class);

    public static DiscoveryConfiguration load(HttpServletRequest request, DiscoveryConfiguration config) {
        String initSTStr = request.getParameter("initialsleeptime");
        String restartSTStr = request.getParameter("restartsleeptime");
        String foreignSource = request.getParameter("foreignsource");
        String location = request.getParameter("location");
        String retriesStr = request.getParameter("retries");
        String timeoutStr = request.getParameter("timeout");
        String chunksizeStr = request.getParameter("chunksize");
        LOG.debug("initialsleeptime: {}", (Object)initSTStr);
        LOG.debug("restartsleeptime: {}", (Object)restartSTStr);
        LOG.debug("foreignSource: {}", (Object)foreignSource);
        LOG.debug("location: {}", (Object)location);
        LOG.debug("retries: {}", (Object)retriesStr);
        LOG.debug("timeout: {}", (Object)timeoutStr);
        LOG.debug("chunksize: {}", (Object)chunksizeStr);
        try {
            long initSt = WebSecurityUtils.safeParseLong((String)initSTStr);
            config.setInitialSleepTime(Long.valueOf(initSt));
        }
        catch (NumberFormatException e) {
            LOG.debug("Null value in discovery config for initial sleep");
        }
        try {
            long restartSt = WebSecurityUtils.safeParseLong((String)restartSTStr);
            config.setRestartSleepTime(Long.valueOf(restartSt));
        }
        catch (NumberFormatException e) {
            LOG.debug("Null value in discovery config for restart sleep");
        }
        if (foreignSource != null && !"".equals(foreignSource.trim())) {
            config.setForeignSource(foreignSource);
        } else {
            config.setForeignSource(null);
        }
        if (location != null && !"".equals(location.trim())) {
            config.setLocation(location);
        } else {
            config.setLocation(null);
        }
        if (retriesStr != null && !"".equals(retriesStr.trim()) && !String.valueOf(1).equals(retriesStr.trim())) {
            config.setRetries(Integer.valueOf(WebSecurityUtils.safeParseInt((String)retriesStr)));
        } else {
            config.setRetries(null);
        }
        if (timeoutStr != null && !"".equals(timeoutStr.trim()) && !String.valueOf(2000L).equals(timeoutStr.trim())) {
            config.setTimeout(Long.valueOf(Long.parseLong(timeoutStr)));
        } else {
            config.setTimeout(null);
        }
        if (chunksizeStr != null && !"".equals(chunksizeStr.trim()) && !String.valueOf(100).equals(chunksizeStr.trim())) {
            config.setChunkSize(Integer.valueOf(Integer.parseInt(chunksizeStr)));
        } else {
            config.setChunkSize(null);
        }
        LOG.debug("General settings uploaded.");
        return config;
    }
}

