/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.net.InetAddress;
import java.util.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;

public class Node {
    private final int m_nodeId;
    private final InetAddress m_snmpprimaryaddr;
    private final String m_sysoid;
    private final String m_sysname;
    private final String m_label;
    private final String m_location;

    public String getLocation() {
        return this.m_location;
    }

    public Node(int nodeId, String label, InetAddress snmpPrimaryAddr, String sysoid, String sysname, String location) {
        this.m_nodeId = nodeId;
        this.m_label = label;
        this.m_snmpprimaryaddr = snmpPrimaryAddr;
        this.m_sysoid = sysoid;
        this.m_sysname = sysname;
        this.m_location = location;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("nodeId", this.m_nodeId).append("snmpPrimaryAddr", (Object)InetAddressUtils.str((InetAddress)this.m_snmpprimaryaddr)).append("sysOid", (Object)this.m_sysoid).toString();
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public InetAddress getSnmpPrimaryIpAddr() {
        return this.m_snmpprimaryaddr;
    }

    public String getSysoid() {
        return this.m_sysoid;
    }

    public String getSysname() {
        return this.m_sysname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.m_nodeId, node.m_nodeId) && Objects.equals(this.m_snmpprimaryaddr, node.m_snmpprimaryaddr);
    }

    public int hashCode() {
        return Objects.hash(this.m_nodeId, this.m_snmpprimaryaddr);
    }

    public String getLabel() {
        return this.m_label;
    }
}

