/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.config.collector.AddressRange;
import org.opennms.integration.api.v1.config.collector.Collector;
import org.opennms.integration.api.v1.config.collector.CollectorConfigurationExtension;
import org.opennms.integration.api.v1.config.collector.Package;
import org.opennms.integration.api.v1.config.collector.Parameter;
import org.opennms.integration.api.v1.config.collector.Service;
import org.opennms.integration.api.xml.ClasspathXmlLoader;
import org.opennms.integration.api.xml.schema.collector.AddressRangeXml;
import org.opennms.integration.api.xml.schema.collector.CollectorConfigurationXml;
import org.opennms.integration.api.xml.schema.collector.CollectorXml;
import org.opennms.integration.api.xml.schema.collector.PackageXml;
import org.opennms.integration.api.xml.schema.collector.ParameterXml;
import org.opennms.integration.api.xml.schema.collector.ServiceXml;
import org.opennms.shaded.com.google.common.base.MoreObjects;

public class ClasspathCollectorConfigurationLoader
extends ClasspathXmlLoader<CollectorConfigurationXml> {
    public ClasspathCollectorConfigurationLoader(Class<?> clazz, String subFolder, String ... fileNames) {
        super(clazz, CollectorConfigurationXml.class, subFolder, fileNames);
    }

    public CollectorConfigurationExtension getCollectorConfiguration() {
        final List configurations = this.getObjects();
        return new CollectorConfigurationExtension(){

            public List<Package> getPackages() {
                return configurations.stream().flatMap(c -> c.getPackages().stream()).map(x$0 -> ClasspathCollectorConfigurationLoader.mapXml(x$0)).collect(Collectors.toUnmodifiableList());
            }

            public List<Collector> getCollectors() {
                return configurations.stream().flatMap(c -> c.getCollectors().stream()).map(x$0 -> ClasspathCollectorConfigurationLoader.mapXml(x$0)).collect(Collectors.toUnmodifiableList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("CollectorConfigurationExtension").add("packages", this.getPackages()).add("collectors", this.getCollectors()).toString();
            }
        };
    }

    private static Package mapXml(final PackageXml source) {
        return new Package(){

            public String getName() {
                return source.getName();
            }

            public String getFilter() {
                return source.getFilter();
            }

            public List<String> getSpecifics() {
                return source.getSpecifics();
            }

            public List<AddressRange> getIncludeRanges() {
                return source.getIncludeRanges().stream().map(x$0 -> ClasspathCollectorConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public List<AddressRange> getExcludeRanges() {
                return source.getExcludeRanges().stream().map(x$0 -> ClasspathCollectorConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public List<Service> getServices() {
                return source.getServices().stream().map(x$0 -> ClasspathCollectorConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("Package").add("name", this.getName()).add("filter", this.getFilter()).add("specific", this.getSpecifics()).add("includeRange", this.getIncludeRanges()).add("excludeRange", this.getExcludeRanges()).add("services", this.getServices()).toString();
            }
        };
    }

    private static Service mapXml(final ServiceXml serviceXml) {
        return new Service(){

            public String getName() {
                return serviceXml.getName();
            }

            public long getInterval() {
                return serviceXml.getInterval();
            }

            public List<Parameter> getParameters() {
                return serviceXml.getParameters().stream().map(x$0 -> ClasspathCollectorConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("Service").add("name", this.getName()).add("interval", this.getInterval()).add("parameters", this.getParameters()).toString();
            }
        };
    }

    private static Parameter mapXml(final ParameterXml parameterXml) {
        return new Parameter(){

            public String getKey() {
                return parameterXml.getKey();
            }

            public String getValue() {
                return parameterXml.getValue();
            }

            public String toString() {
                return MoreObjects.toStringHelper("Parameter").add("key", this.getKey()).add("value", this.getValue()).toString();
            }
        };
    }

    private static AddressRange mapXml(final AddressRangeXml addressRangeXml) {
        return new AddressRange(){

            public String getBegin() {
                return addressRangeXml.getBegin();
            }

            public String getEnd() {
                return addressRangeXml.getEnd();
            }

            public String toString() {
                return MoreObjects.toStringHelper("AddressRange").add("begin", this.getBegin()).add("end", this.getEnd()).toString();
            }
        };
    }

    private static Collector mapXml(final CollectorXml collector) {
        return new Collector(){

            public String getService() {
                return collector.getService();
            }

            public String getClassName() {
                return collector.getClassName();
            }

            public List<Parameter> getParameters() {
                return collector.getParameters().stream().map(x$0 -> ClasspathCollectorConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("Monitor").add("service", this.getService()).add("className", this.getClassName()).add("parameters", this.getParameters()).toString();
            }
        };
    }
}

