/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.ExecutorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassExecutor
implements ExecutorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClassExecutor.class);

    @Override
    public int execute(String className, List<Argument> arguments) {
        NotificationStrategy ns;
        LOG.debug("Going for the class instance: {}", (Object)className);
        try {
            ns = (NotificationStrategy)Class.forName(className).newInstance();
            LOG.debug("{} class created: {}", (Object)className, ns.getClass());
        }
        catch (Throwable e) {
            LOG.error("Execption creating notification strategy class: {}", (Object)className, (Object)e);
            return 1;
        }
        try {
            return ns.send(arguments);
        }
        catch (Throwable t) {
            LOG.error("Throwable received while sending message", t);
            return 1;
        }
    }
}

