/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import java.util.UUID;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.browser.BrowserNotificationDispatcher;
import org.opennms.netmgt.notifd.browser.BrowserNotificationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserNotificationStrategy.class);

    public int send(List<Argument> arguments) {
        String user = null;
        String head = null;
        String body = null;
        for (Argument argument : arguments) {
            switch (argument.getSwitch()) {
                case "-d": {
                    user = argument.getValue();
                    break;
                }
                case "-subject": {
                    head = argument.getValue();
                    break;
                }
                case "-tm": 
                case "-nm": {
                    body = argument.getValue();
                }
            }
        }
        BrowserNotificationMessage message = new BrowserNotificationMessage();
        message.setId(UUID.randomUUID().toString());
        message.setHead(head);
        message.setBody(body);
        BrowserNotificationDispatcher.getInstance().notify(user, message);
        return 0;
    }
}

