/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.keyword;

import com.atlassian.oai.validator.util.ValidationReportUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscriminatorKeywordValidator
extends AbstractKeywordValidator {
    private static final Logger log = LoggerFactory.getLogger(DiscriminatorKeywordValidator.class);
    private static final String VALIDATION_PROPERTY_NAME = "_discriminatorValidation";
    private final String propertyName;
    private final JsonNode mappingNode;

    public DiscriminatorKeywordValidator(JsonNode digest) {
        super("discriminator");
        this.propertyName = digest.get(this.keyword).get("propertyName").textValue();
        this.mappingNode = digest.get(this.keyword).get("mapping");
    }

    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        this.doValidate(processor, report, bundle, data);
    }

    public void doValidate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode discriminatorNode = data.getInstance().getNode().get(this.propertyName);
        if (discriminatorNode == null) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.missing").putArgument("discriminatorField", (Object)this.propertyName));
            return;
        }
        if (!discriminatorNode.isTextual()) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.nonText").putArgument("discriminatorField", (Object)this.propertyName));
            return;
        }
        String discriminatorPropertyValue = discriminatorNode.textValue();
        if (discriminatorPropertyValue.isEmpty()) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.missing").putArgument("discriminatorField", (Object)this.propertyName));
            return;
        }
        JsonNode currentSchemaNode = data.getSchema().getNode();
        if (currentSchemaNode.has("anyOf")) {
            this.validateOneOfAnyOfComposition(processor, report, bundle, data, discriminatorNode, currentSchemaNode.get("anyOf"));
        } else if (currentSchemaNode.has("oneOf")) {
            this.validateOneOfAnyOfComposition(processor, report, bundle, data, discriminatorNode, currentSchemaNode.get("oneOf"));
        } else {
            this.validateAllOfComposition(processor, report, bundle, data, discriminatorNode);
        }
    }

    private void validateOneOfAnyOfComposition(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data, JsonNode discriminatorNode, JsonNode compositionNode) throws ProcessingException {
        SchemaTree schemaTree = data.getSchema();
        String discriminatorPropertyValue = discriminatorNode.textValue();
        String nodes = this.filterDiscriminatorValidationNodes(schemaTree.getPointer()).toString();
        Map<String, JsonNode> validDiscriminatorValues = this.findValidDirectDiscriminatorValues(data, compositionNode);
        this.validateDiscriminatedComposition(processor, report, bundle, data, discriminatorNode, validDiscriminatorValues, discriminatorPropertyValue, schemaTree);
    }

    private void validateAllOfComposition(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data, JsonNode discriminatorNode) throws ProcessingException {
        SchemaTree schemaTree = data.getSchema();
        String discriminatorPropertyValue = discriminatorNode.textValue();
        Map<String, JsonNode> validDiscriminatorValues = this.findValidDiscriminatorValues(data, "#" + this.filterDiscriminatorValidationNodes(schemaTree.getPointer()).toString());
        this.validateDiscriminatedComposition(processor, report, bundle, data, discriminatorNode, validDiscriminatorValues, discriminatorPropertyValue, schemaTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDiscriminatedComposition(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data, JsonNode discriminatorNode, Map<String, JsonNode> validDiscriminatorValues, String discriminatorPropertyValue, SchemaTree schemaTree) throws ProcessingException {
        if (!validDiscriminatorValues.containsKey(discriminatorPropertyValue)) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.invalid").putArgument("discriminatorField", (Object)this.propertyName).putArgument("value", (Object)discriminatorPropertyValue).putArgument("allowedValues", validDiscriminatorValues.keySet()));
        }
        JsonPointer ptrToChildSchema = this.pointerToDiscriminatedSchema(data, this.mappedDiscriminatorNode(discriminatorNode, discriminatorPropertyValue));
        SchemaTree childSchemaTree = schemaTree.setPointer(ptrToChildSchema);
        ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
        if (childSchemaTree.getNode() == null || childSchemaTree.getNode().isMissingNode()) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.reference.invalid").putArgument("schema", (Object)ptrToChildSchema.toString()).put("report", subReport.asJson()));
            return;
        }
        ObjectNode childSchemaAsObject = (ObjectNode)childSchemaTree.getNode();
        if (!childSchemaAsObject.has(VALIDATION_PROPERTY_NAME)) {
            ObjectNode objectNode = childSchemaAsObject;
            synchronized (objectNode) {
                if (!childSchemaAsObject.has(VALIDATION_PROPERTY_NAME)) {
                    childSchemaAsObject.set(VALIDATION_PROPERTY_NAME, (JsonNode)childSchemaAsObject.objectNode());
                }
            }
        }
        ObjectNode validationPropertyNode = (ObjectNode)childSchemaAsObject.get(VALIDATION_PROPERTY_NAME);
        String discriminatorValidationContextString = new VisitedInfo(data.getInstance().getPointer(), data.getSchema().getPointer(), discriminatorPropertyValue).toString();
        String threadIdAndDiscriminatorCombo = Thread.currentThread().getId() + "-" + discriminatorValidationContextString;
        if (validationPropertyNode.has(threadIdAndDiscriminatorCombo)) {
            return;
        }
        boolean setThreadMarkerOnValidationPropertiesNode = false;
        try {
            ObjectNode objectNode = validationPropertyNode;
            synchronized (objectNode) {
                block28: {
                    if (!validationPropertyNode.has(threadIdAndDiscriminatorCombo)) break block28;
                    return;
                }
                validationPropertyNode.set(threadIdAndDiscriminatorCombo, (JsonNode)childSchemaAsObject.booleanNode(true));
                setThreadMarkerOnValidationPropertiesNode = true;
                if (!validationPropertyNode.has(discriminatorValidationContextString)) {
                    validationPropertyNode.set(discriminatorValidationContextString, (JsonNode)childSchemaAsObject);
                }
            }
            SchemaTree childSchemaTreeWithRewrittenPointer = childSchemaTree.setPointer(ptrToChildSchema.append(VALIDATION_PROPERTY_NAME).append(discriminatorValidationContextString));
            FullData newData = data.withSchema(childSchemaTreeWithRewrittenPointer);
            processor.process((ProcessingReport)subReport, (MessageProvider)newData);
        }
        finally {
            if (setThreadMarkerOnValidationPropertiesNode) {
                ObjectNode objectNode = validationPropertyNode;
                synchronized (objectNode) {
                    validationPropertyNode.remove(threadIdAndDiscriminatorCombo);
                }
            }
        }
        if (!subReport.isSuccess()) {
            String stringToReplace = "/_discriminatorValidation/" + discriminatorValidationContextString.replaceAll("\\/", "~1");
            JsonNode reportAsJson = subReport.asJson();
            ValidationReportUtils.replaceReportOutput(reportAsJson, stringToReplace, "");
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.fail").putArgument("schema", (Object)ptrToChildSchema.toString()).put("reports", reportAsJson));
        }
    }

    private JsonPointer filterDiscriminatorValidationNodes(JsonPointer originalPointer) {
        JsonPointer ret = JsonPointer.empty();
        Iterator pointerPartIterator = originalPointer.iterator();
        while (pointerPartIterator.hasNext()) {
            TokenResolver pointerPart = (TokenResolver)pointerPartIterator.next();
            if (VALIDATION_PROPERTY_NAME.equals(pointerPart.toString())) {
                pointerPartIterator.next();
                continue;
            }
            ret = ret.append(pointerPart.toString());
        }
        return ret;
    }

    private JsonNode mappedDiscriminatorNode(JsonNode originalDiscriminatorNode, String discriminatorPropertyValue) {
        if (this.mappingNode != null && this.mappingNode.get(discriminatorPropertyValue) != null) {
            return this.mappingNode.get(discriminatorPropertyValue);
        }
        return originalDiscriminatorNode;
    }

    private Map<String, JsonNode> findValidDirectDiscriminatorValues(FullData data, JsonNode compositionNode) {
        HashMap<String, JsonNode> validDiscriminatorValues = new HashMap<String, JsonNode>();
        compositionNode.forEach(alternative -> {
            if (alternative.has("$ref")) {
                String reference = alternative.get("$ref").textValue();
                validDiscriminatorValues.put(this.normalizeDiscriminatorNode(reference), (JsonNode)alternative);
            } else {
                this.definitionsNode(data).fields().forEachRemaining(e -> {
                    JsonNode def = (JsonNode)e.getValue();
                    if (alternative.equals((Object)def)) {
                        validDiscriminatorValues.put((String)e.getKey(), def);
                    }
                });
            }
        });
        if (this.mappingNode != null) {
            this.mappingNode.fields().forEachRemaining(e -> validDiscriminatorValues.put((String)e.getKey(), (JsonNode)e.getValue()));
        }
        return validDiscriminatorValues;
    }

    private Map<String, JsonNode> findValidDiscriminatorValues(FullData data, String parentDefinitionRef) {
        HashMap<String, JsonNode> validDiscriminatorValues = new HashMap<String, JsonNode>();
        this.definitionsNode(data).fields().forEachRemaining(e -> {
            JsonNode def = (JsonNode)e.getValue();
            if (!def.has("allOf")) {
                return;
            }
            def.get("allOf").forEach(n -> {
                if (n.has("$ref") && n.get("$ref").textValue().equals(parentDefinitionRef)) {
                    validDiscriminatorValues.put((String)e.getKey(), def);
                }
            });
        });
        if (this.mappingNode != null) {
            this.mappingNode.fields().forEachRemaining(e -> validDiscriminatorValues.put((String)e.getKey(), (JsonNode)e.getValue()));
        }
        return validDiscriminatorValues;
    }

    private JsonPointer pointerToDiscriminatedSchema(FullData data, JsonNode discriminatorNode) {
        String discriminatorNodeText = this.normalizeDiscriminatorNode(discriminatorNode.textValue());
        if (data.getSchema().getBaseNode().has("components")) {
            return JsonPointer.of((Object)"components", (Object[])new Object[]{"schemas", discriminatorNodeText});
        }
        return JsonPointer.of((Object)"definitions", (Object[])new Object[]{discriminatorNodeText});
    }

    private JsonNode definitionsNode(FullData data) {
        JsonNode baseNode = data.getSchema().getBaseNode();
        if (baseNode.has("components")) {
            return baseNode.get("components").get("schemas");
        }
        return baseNode.get("definitions");
    }

    private String normalizeDiscriminatorNode(String discriminatorNodeText) {
        if (discriminatorNodeText.startsWith("#/")) {
            int n = discriminatorNodeText.lastIndexOf(47);
            return discriminatorNodeText.substring(n + 1);
        }
        return discriminatorNodeText;
    }

    public String toString() {
        return this.keyword;
    }

    private ProcessingMessage msg(FullData data, MessageBundle bundle, String key) {
        return this.newMsg(data, bundle, key).put("key", key);
    }

    private static class VisitedInfo {
        private final JsonPointer instancePointer;
        private final JsonPointer schemaPointer;
        private final String contextId;

        public VisitedInfo(JsonPointer instancePointer, JsonPointer schemaPointer, String contextId) {
            this.instancePointer = instancePointer;
            this.schemaPointer = schemaPointer;
            this.contextId = contextId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VisitedInfo that = (VisitedInfo)o;
            return Objects.equals(this.instancePointer, that.instancePointer) && Objects.equals(this.schemaPointer, that.schemaPointer) && Objects.equals(this.contextId, that.contextId);
        }

        public int hashCode() {
            return Objects.hash(this.instancePointer, this.schemaPointer, this.contextId);
        }

        public String toString() {
            return this.schemaPointer.toString() + "//" + this.instancePointer.toString() + "//" + this.contextId;
        }
    }
}

