/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.report.EmptyValidationReport;
import com.atlassian.oai.validator.report.ImmutableMessage;
import com.atlassian.oai.validator.report.ImmutableMessageContext;
import com.atlassian.oai.validator.report.ImmutableValidationReport;
import com.atlassian.oai.validator.report.MergedValidationReport;
import com.atlassian.oai.validator.whitelist.NamedWhitelistRule;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ValidationReport {
    public static ValidationReport empty() {
        return new EmptyValidationReport();
    }

    public static ValidationReport singleton(@Nullable Message message) {
        if (message == null) {
            return ValidationReport.empty();
        }
        return new ImmutableValidationReport(message);
    }

    public static ValidationReport from(Collection<Message> messages) {
        return ValidationReport.from(messages.toArray(new Message[messages.size()]));
    }

    public static ValidationReport from(Message ... messages) {
        if (messages == null || messages.length == 0) {
            return ValidationReport.empty();
        }
        return new ImmutableValidationReport(messages);
    }

    default public boolean hasErrors() {
        return this.getMessages().stream().anyMatch(m -> m.getLevel() == Level.ERROR);
    }

    default public Set<Level> sortedValidationLevels() {
        return this.getMessages().stream().map(Message::getLevel).collect(Collectors.toCollection(TreeSet::new));
    }

    @Nonnull
    public List<Message> getMessages();

    default public ValidationReport merge(@Nonnull ValidationReport other) {
        Objects.requireNonNull(other, "A validation report is required");
        return new MergedValidationReport(this, other);
    }

    public ValidationReport withAdditionalContext(MessageContext var1);

    public static interface Message {
        public static Builder create(String key, String message) {
            return new Builder(key, Level.ERROR, message);
        }

        public String getKey();

        public String getMessage();

        public Level getLevel();

        public List<String> getAdditionalInfo();

        default public List<Message> getNestedMessages() {
            return Collections.emptyList();
        }

        public Optional<MessageContext> getContext();

        public Message withLevel(Level var1);

        public Message withAdditionalInfo(String var1);

        default public Message withNestedMessages(Collection<Message> messages) {
            return this;
        }

        public Message withAdditionalContext(MessageContext var1);

        public static class Builder {
            private final String key;
            private final Level level;
            private final String message;
            private final List<String> additionalInfo = new ArrayList<String>();
            private MessageContext context;

            private Builder(@Nonnull String key, @Nonnull Level level, @Nonnull String message) {
                this.key = Objects.requireNonNull(key, "A key is required");
                this.level = Objects.requireNonNull(level, "A level is required");
                this.message = Objects.requireNonNull(message, "A message is required");
            }

            public Builder withAdditionalInfo(List<String> additionalInfo) {
                if (additionalInfo != null) {
                    this.additionalInfo.addAll(additionalInfo);
                }
                return this;
            }

            public Builder withAdditionalInfo(String ... additionalInfo) {
                this.additionalInfo.addAll(Arrays.asList(additionalInfo));
                return this;
            }

            public Builder withContext(MessageContext context) {
                this.context = context;
                return this;
            }

            public Message build() {
                return new ImmutableMessage(this.key, this.level, this.message, this.additionalInfo, this.context);
            }
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        IGNORE;

    }

    public static interface MessageContext {
        public static MessageContext empty() {
            return MessageContext.create().build();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder from(MessageContext other) {
            return new Builder(other);
        }

        public Optional<String> getRequestPath();

        public Optional<Request.Method> getRequestMethod();

        public Optional<ApiOperation> getApiOperation();

        public Optional<String> getApiRequestContentType();

        public Optional<RequestBody> getApiRequestBodyDefinition();

        public Optional<Parameter> getParameter();

        public Optional<Integer> getResponseStatus();

        public Optional<ApiResponse> getApiResponseDefinition();

        public Optional<Location> getLocation();

        public Optional<NamedWhitelistRule> getAppliedWhitelistRule();

        public Optional<Pointers> getPointers();

        public boolean hasData();

        public MessageContext enhanceWith(MessageContext var1);

        public static class Builder {
            String requestPath;
            Request.Method method;
            ApiOperation apiOperation;
            Parameter parameter;
            String apiRequestContentType;
            RequestBody apiRequestBodyDefinition;
            Integer responseStatus;
            ApiResponse apiResponse;
            Location location;
            NamedWhitelistRule whitelistRule;
            Pointers pointers;

            private Builder() {
            }

            private Builder(MessageContext init) {
                this.requestPath = init.getRequestPath().orElse(null);
                this.method = init.getRequestMethod().orElse(null);
                this.apiOperation = init.getApiOperation().orElse(null);
                this.parameter = init.getParameter().orElse(null);
                this.apiRequestBodyDefinition = init.getApiRequestBodyDefinition().orElse(null);
                this.apiRequestContentType = init.getApiRequestContentType().orElse(null);
                this.responseStatus = init.getResponseStatus().orElse(null);
                this.apiResponse = init.getApiResponseDefinition().orElse(null);
                this.location = init.getLocation().orElse(null);
                this.whitelistRule = init.getAppliedWhitelistRule().orElse(null);
                this.pointers = init.getPointers().orElse(null);
            }

            public Builder withRequestPath(String requestPath) {
                this.requestPath = requestPath;
                return this;
            }

            public Builder withRequestMethod(Request.Method method) {
                this.method = method;
                return this;
            }

            public Builder withApiOperation(ApiOperation apiOperation) {
                this.apiOperation = apiOperation;
                return this;
            }

            public Builder withParameter(Parameter parameter) {
                this.parameter = parameter;
                return this;
            }

            public Builder withApiRequestBodyDefinition(RequestBody requestBody) {
                this.apiRequestBodyDefinition = requestBody;
                return this;
            }

            public Builder withMatchedApiContentType(String contentType) {
                this.apiRequestContentType = contentType;
                return this;
            }

            public Builder withResponseStatus(Integer status) {
                this.responseStatus = status;
                return this;
            }

            public Builder withApiResponseDefinition(ApiResponse apiResponseDefinition) {
                this.apiResponse = apiResponseDefinition;
                return this;
            }

            public Builder in(Location location) {
                this.location = location;
                return this;
            }

            public Builder withAppliedWhitelistRule(NamedWhitelistRule whitelistRule) {
                this.whitelistRule = whitelistRule;
                return this;
            }

            public Builder withPointers(String instance, String schema) {
                this.pointers = new Pointers(instance, schema);
                return this;
            }

            public Builder withAdditionalDataFrom(MessageContext other) {
                if (this.requestPath == null) {
                    this.requestPath = other.getRequestPath().orElse(null);
                }
                if (this.method == null) {
                    this.method = other.getRequestMethod().orElse(null);
                }
                if (this.apiOperation == null) {
                    this.apiOperation = other.getApiOperation().orElse(null);
                }
                if (this.parameter == null) {
                    this.parameter = other.getParameter().orElse(null);
                }
                if (this.apiRequestContentType == null) {
                    this.apiRequestContentType = other.getApiRequestContentType().orElse(null);
                }
                if (this.apiRequestBodyDefinition == null) {
                    this.apiRequestBodyDefinition = other.getApiRequestBodyDefinition().orElse(null);
                }
                if (this.responseStatus == null) {
                    this.responseStatus = other.getResponseStatus().orElse(null);
                }
                if (this.apiResponse == null) {
                    this.apiResponse = other.getApiResponseDefinition().orElse(null);
                }
                if (this.location == null) {
                    this.location = other.getLocation().orElse(null);
                }
                if (this.whitelistRule == null) {
                    this.whitelistRule = other.getAppliedWhitelistRule().orElse(null);
                }
                if (this.pointers == null) {
                    this.pointers = other.getPointers().orElse(null);
                }
                return this;
            }

            public MessageContext build() {
                return new ImmutableMessageContext(this);
            }
        }

        public static class Pointers {
            private final String instance;
            private final String schema;

            public Pointers(String instance, String schema) {
                this.instance = instance;
                this.schema = schema;
            }

            public String getInstance() {
                return this.instance;
            }

            public String getSchema() {
                return this.schema;
            }
        }

        public static enum Location {
            REQUEST,
            RESPONSE;

        }
    }
}

