/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.LevelLoader;
import com.atlassian.oai.validator.report.ValidationReport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LevelResolver {
    private final ValidationReport.Level defaultLevel;
    private final Map<String, ValidationReport.Level> levels = new ConcurrentHashMap<String, ValidationReport.Level>();

    public static Builder create() {
        return new Builder();
    }

    public static LevelResolver defaultResolver() {
        return new Builder().withLevel("validation.request.parameter.query.unexpected", ValidationReport.Level.IGNORE).build();
    }

    private LevelResolver(@Nullable Map<String, ValidationReport.Level> levels, @Nullable ValidationReport.Level defaultLevel) {
        if (levels != null) {
            this.levels.putAll(levels);
        }
        this.defaultLevel = defaultLevel == null ? ValidationReport.Level.ERROR : defaultLevel;
    }

    @Nonnull
    public ValidationReport.Level getLevel(@Nullable String key) {
        if (key == null || key.isEmpty()) {
            return this.defaultLevel;
        }
        if (this.levels.containsKey(key)) {
            return this.levels.get(key);
        }
        String parentKey = key.substring(0, Math.max(0, key.lastIndexOf(46)));
        ValidationReport.Level result = this.getLevel(parentKey);
        this.levels.put(key, result);
        return result;
    }

    public static class Builder {
        private ValidationReport.Level defaultLevel;
        private Map<String, ValidationReport.Level> levels = new HashMap<String, ValidationReport.Level>();
        private LevelLoader loader;
        private boolean useDefaultLoader = true;

        public Builder withLoader(LevelLoader loader) {
            this.loader = loader;
            this.useDefaultLoader = false;
            return this;
        }

        public Builder withDefaultLevel(ValidationReport.Level defaultLevel) {
            this.defaultLevel = defaultLevel;
            return this;
        }

        public Builder withLevels(Map<String, ValidationReport.Level> levels) {
            this.levels.putAll(levels);
            return this;
        }

        public Builder withLevel(String key, ValidationReport.Level level) {
            this.levels.put(key, level);
            return this;
        }

        public LevelResolver build() {
            HashMap<String, ValidationReport.Level> levels = new HashMap<String, ValidationReport.Level>();
            if (this.useDefaultLoader) {
                this.loader = LevelLoader.defaultLoaderChain();
            }
            ValidationReport.Level defaultLevel = this.defaultLevel;
            levels.putAll(LevelLoader.defaultsLoader().loadLevels());
            levels.putAll(this.levels);
            if (this.loader != null) {
                levels.putAll(this.loader.loadLevels());
                defaultLevel = this.loader.defaultLevel().orElse(this.defaultLevel);
            }
            return new LevelResolver(levels, defaultLevel);
        }
    }
}

