/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.ValidationReport;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ImmutableValidationReport
implements ValidationReport {
    private final List<ValidationReport.Message> messages;

    ImmutableValidationReport(ValidationReport.Message message) {
        if (message == null) {
            this.messages = Collections.emptyList();
            return;
        }
        this.messages = ImmutableList.of((Object)message);
    }

    ImmutableValidationReport(ValidationReport.Message ... messages) {
        if (messages == null || messages.length == 0) {
            this.messages = Collections.emptyList();
            return;
        }
        this.messages = ImmutableList.copyOf((Collection)Arrays.stream(messages).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    ImmutableValidationReport(List<ValidationReport.Message> messages) {
        if (messages == null || messages.size() == 0) {
            this.messages = Collections.emptyList();
            return;
        }
        this.messages = ImmutableList.copyOf((Collection)messages.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<ValidationReport.Message> getMessages() {
        return this.messages;
    }

    public String toString() {
        return this.getMessages().toString();
    }

    @Override
    public ValidationReport withAdditionalContext(ValidationReport.MessageContext context) {
        return new ImmutableValidationReport(this.messages.stream().map(m -> m.withAdditionalContext(context)).collect(Collectors.toList()));
    }
}

