/*
 * Decompiled with CFR 0.152.
 */
package org.openbmp.api.parsed.processor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.openbmp.api.helpers.split;
import org.openbmp.api.parsed.message.CollectorPojo;

public class Collector {
    public List<CollectorPojo> records;

    public Collector(String data) {
        this.records = this.parseData(data);
    }

    List<CollectorPojo> parseData(String data) {
        List<String> records = split.getStrings(data, '\n', 5000);
        ArrayList<CollectorPojo> results = new ArrayList<CollectorPojo>();
        for (String record : records) {
            if (record.length() <= 3) continue;
            CollectorPojo entry = this.parseRecord(record);
            results.add(entry);
        }
        return results;
    }

    CollectorPojo parseRecord(String data) {
        List<String> fields = split.getStrings(data, '\t', 500);
        CollectorPojo pojo = new CollectorPojo();
        try {
            pojo.setAction(fields.get(0));
            pojo.setSequence(BigInteger.valueOf(Long.parseLong(fields.get(1))));
            pojo.setAdmin_id(fields.get(2));
            pojo.setHash(fields.get(3));
            pojo.setRouter_list(fields.get(4));
            pojo.setRouter_count(Integer.parseInt(fields.get(5)));
            pojo.setTimestamp(fields.get(6));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pojo;
    }
}

