/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j.opaqueadapter;

import java.util.Objects;
import org.opennms.netmgt.snmp.snmp4j.OpaqueValueType;
import org.opennms.netmgt.snmp.snmp4j.opaqueadapter.OpaqueTypeAdapter;

public class StringWithNumberCheckAdapter
implements OpaqueTypeAdapter {
    String stringValue;
    Long longValue;
    Double doubleValue;
    OpaqueValueType valueType;

    public StringWithNumberCheckAdapter(String value) {
        this.stringValue = Objects.requireNonNull(value);
        try {
            this.longValue = Long.parseLong(value);
            this.doubleValue = (double)this.longValue;
            this.valueType = OpaqueValueType.LONG;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.doubleValue = Double.valueOf(value);
                this.longValue = this.doubleValue.longValue();
                this.valueType = OpaqueValueType.DOUBLE;
                return;
            }
            catch (NumberFormatException numberFormatException2) {
                this.doubleValue = null;
                this.longValue = null;
                this.valueType = OpaqueValueType.STRING;
                return;
            }
        }
    }

    @Override
    public Long getLong() {
        return this.longValue;
    }

    @Override
    public Double getDouble() {
        return this.doubleValue;
    }

    @Override
    public String getString() {
        return this.stringValue;
    }

    @Override
    public OpaqueValueType getValueType() {
        return this.valueType;
    }
}

