/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.nustaq.serialization.FSTConfiguration;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.distributed.kvstore.api.BlobStore;
import org.opennms.features.distributed.kvstore.api.SerializingBlobStore;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;
import org.opennms.netmgt.threshd.ExpressionThresholdValueSupplier;
import org.opennms.netmgt.threshd.ThresholdEvaluatorAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRearmingAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdValuesSupplier;
import org.opennms.netmgt.threshd.api.ReinitializableState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThresholdEvaluatorState<T extends AbstractState>
implements ThresholdEvaluatorState {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThresholdEvaluatorState.class);
    private static final RateLimitedLog RATE_LIMITED_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private static final String UNKNOWN = "Unknown";
    public static final String FORMATED_NAN = "NaN (the threshold definition has been changed)";
    public static final FSTConfiguration fst = FSTConfiguration.createDefaultConfiguration();
    private boolean isStateDirty;
    private String key;
    private final SerializingBlobStore<T> kvStore;
    protected T state;
    protected final ThresholdingSession thresholdingSession;
    static final String THRESHOLDING_KV_CONTEXT = "thresholding";
    private final int stateTTL = SystemProperties.getInteger((String)"org.opennms.netmgt.threshd.state_ttl", (int)((int)TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS)));
    private Long sequenceNumber;
    private boolean firstEvaluation = true;
    private String instance;
    static final Map<Class<? extends AbstractState>, SerializingBlobStore<? extends AbstractState>> serdesMap;
    private static final Map<String, Long> lastUpdatedCache;

    AbstractThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession, Class<T> stateType) {
        Objects.requireNonNull(threshold);
        Objects.requireNonNull(thresholdingSession);
        Objects.requireNonNull(thresholdingSession.getBlobStore());
        this.thresholdingSession = thresholdingSession;
        this.kvStore = AbstractThresholdEvaluatorState.getKvStoreForType(stateType, thresholdingSession.getBlobStore());
        this.key = String.format("%d-%s-%s-%s-%s-%s", thresholdingSession.getKey().getNodeId(), thresholdingSession.getKey().getLocation(), threshold.getDsType(), threshold.getDatasourceExpression(), threshold.getType(), this.generateHashForThresholdValues(threshold));
        this.initializeState();
    }

    private String generateHashForThresholdValues(BaseThresholdDefConfigWrapper threshold) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        if (threshold.getTriggeredUEI().isPresent()) {
            hasher.putString((CharSequence)threshold.getTriggeredUEI().get(), StandardCharsets.UTF_8);
        }
        if (threshold.getRearmedUEI().isPresent()) {
            hasher.putString((CharSequence)threshold.getRearmedUEI().get(), StandardCharsets.UTF_8);
        }
        if (threshold.getValue() != null) {
            hasher.putDouble(threshold.getValue().doubleValue());
        } else if (!Strings.isNullOrEmpty((String)threshold.getValueString())) {
            hasher.putString((CharSequence)threshold.getValueString(), StandardCharsets.UTF_8);
        }
        if (threshold.getRearm() != null) {
            hasher.putDouble(threshold.getRearm().doubleValue());
        } else if (!Strings.isNullOrEmpty((String)threshold.getRearmString())) {
            hasher.putString((CharSequence)threshold.getRearmString(), StandardCharsets.UTF_8);
        }
        if (threshold.getTrigger() != null) {
            hasher.putInt(threshold.getTrigger().intValue());
        } else if (!Strings.isNullOrEmpty((String)threshold.getTriggerString())) {
            hasher.putString((CharSequence)threshold.getTriggerString(), StandardCharsets.UTF_8);
        }
        return hasher.hash().toString();
    }

    private static <U extends AbstractState> SerializingBlobStore<U> getKvStoreForType(Class<U> stateType, BlobStore blobStore) {
        return serdesMap.computeIfAbsent(stateType, c -> SerializingBlobStore.ofType((BlobStore)blobStore, arg_0 -> ((FSTConfiguration)fst).asByteArray(arg_0), bytes -> (AbstractState)c.cast(fst.asObject(bytes))));
    }

    protected abstract void initializeState();

    private boolean shouldPersist() {
        return this.isStateDirty;
    }

    private void persistStateIfNeeded() {
        if (this.shouldPersist()) {
            try {
                long newTimestamp = this.kvStore.put(this.key, this.state, THRESHOLDING_KV_CONTEXT, Integer.valueOf(this.stateTTL));
                lastUpdatedCache.put(this.key, newTimestamp);
                this.isStateDirty = false;
            }
            catch (RuntimeException e) {
                RATE_LIMITED_LOGGER.warn("Failed to store state for threshold {}", (Object)this.key, (Object)e);
            }
        }
    }

    private void fetchState() {
        this.thresholdingSession.getThresholdStateMonitor().withReadLock(() -> {
            if (!this.isDistributed() && !this.firstEvaluation) {
                return;
            }
            try {
                Long lastKnownUpdate = lastUpdatedCache.get(this.key);
                if (lastKnownUpdate == null || this.firstEvaluation) {
                    this.kvStore.get(this.key, THRESHOLDING_KV_CONTEXT).ifPresent(v -> {
                        this.state = v;
                    });
                } else {
                    this.kvStore.getIfStale(this.key, THRESHOLDING_KV_CONTEXT, lastKnownUpdate.longValue()).ifPresent(o -> o.ifPresent(v -> {
                        this.state = v;
                    }));
                }
            }
            catch (RuntimeException e) {
                RATE_LIMITED_LOGGER.warn("Failed to retrieve state for threshold {}", (Object)this.key, (Object)e);
            }
        });
    }

    protected void markDirty() {
        this.isStateDirty = true;
    }

    @Override
    public ThresholdEvaluatorState.Status evaluate(double dsValue, Long sequenceNumber) {
        return this.evaluate(dsValue, null, sequenceNumber);
    }

    @Override
    public synchronized ThresholdEvaluatorState.Status evaluate(double dsValue, ThresholdEvaluatorState.ThresholdValues thresholdValues, Long sequenceNumber) {
        if (sequenceNumber != null) {
            if (this.sequenceNumber == null || sequenceNumber != this.sequenceNumber + 1L) {
                this.fetchState();
            }
            this.sequenceNumber = sequenceNumber;
        } else {
            this.fetchState();
        }
        ThresholdEvaluatorState.Status status = this.evaluateAfterFetch(dsValue, thresholdValues);
        if (this.firstEvaluation) {
            this.firstEvaluation = false;
            this.thresholdingSession.getThresholdStateMonitor().trackState(this.key, (ReinitializableState)this);
        }
        this.persistStateIfNeeded();
        this.firstEvaluation = false;
        return status;
    }

    @Override
    public ThresholdEvaluatorState.ValueStatus evaluate(ExpressionThresholdValueSupplier valueSupplier, Long sequenceNumber) throws ThresholdExpressionException {
        ExpressionConfigWrapper.ExpressionThresholdValues expressionThresholdValues = this.getValueForExpressionThreshold(valueSupplier);
        ThresholdEvaluatorState.Status status = this.evaluate(expressionThresholdValues.value, expressionThresholdValues.getThresholdValues(), sequenceNumber);
        return new ThresholdEvaluatorState.ValueStatus(expressionThresholdValues.value, status, expressionThresholdValues.getThresholdValues());
    }

    @Override
    public ThresholdEvaluatorState.ValueStatus evaluate(ThresholdValuesSupplier thresholdValuesSupplier, Long sequenceNumber) throws ThresholdExpressionException {
        ThresholdEvaluatorState.ThresholdValues thresholdValues = this.getThresholdValues(thresholdValuesSupplier);
        ThresholdEvaluatorState.Status status = this.evaluate(thresholdValues.getDsValue(), thresholdValues, sequenceNumber);
        return new ThresholdEvaluatorState.ValueStatus(thresholdValues.getDsValue(), status, thresholdValues);
    }

    private ThresholdEvaluatorState.ThresholdValues getThresholdValues(ThresholdValuesSupplier thresholdValuesSupplier) {
        if (!((AbstractState)this.state).isCached()) {
            ThresholdEvaluatorState.ThresholdValues thresholdValues = thresholdValuesSupplier.get();
            ((AbstractState)this.state).setThresholdValues(thresholdValues);
            ((AbstractState)this.state).setCached(true);
            return thresholdValues;
        }
        Double dsvalue = thresholdValuesSupplier.getDsValue();
        ThresholdEvaluatorState.ThresholdValues thresholdValues = ((AbstractState)this.state).getThresholdValues();
        thresholdValues.setDsValue(dsvalue);
        return thresholdValues;
    }

    private ExpressionConfigWrapper.ExpressionThresholdValues getValueForExpressionThreshold(ExpressionThresholdValueSupplier valueSupplier) throws ThresholdExpressionException {
        if (!((AbstractState)this.state).isCached()) {
            LOG.debug("Interpolating the expression for state {} for the first time", this.state);
            ExpressionConfigWrapper.ExpressionThresholdValues expressionThresholdValues = valueSupplier.get();
            ((AbstractState)this.state).setInterpolatedExpression(expressionThresholdValues.expression);
            ((AbstractState)this.state).setThresholdValues(expressionThresholdValues.getThresholdValues());
            ((AbstractState)this.state).setCached(true);
            return expressionThresholdValues;
        }
        String interpolatedExpression = ((AbstractState)this.state).getInterpolatedExpression().get();
        LOG.debug("Using already cached expression {}", (Object)interpolatedExpression);
        ExpressionConfigWrapper.ExpressionThresholdValues expressionThresholdValues = new ExpressionConfigWrapper.ExpressionThresholdValues(interpolatedExpression, valueSupplier.get(interpolatedExpression));
        expressionThresholdValues.setThresholdValues(((AbstractState)this.state).getThresholdValues());
        return expressionThresholdValues;
    }

    @Override
    public void clearState() {
        this.clearStateBeforePersist();
        this.persistStateIfNeeded();
    }

    public synchronized void reinitialize() {
        this.firstEvaluation = true;
        this.clearStateBeforePersist();
    }

    protected abstract void clearStateBeforePersist();

    protected abstract ThresholdEvaluatorState.Status evaluateAfterFetch(double var1, ThresholdEvaluatorState.ThresholdValues var3);

    protected Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource, Map<String, String> additionalParams) {
        String exprLabelValue;
        String dsLabelValue;
        if (resource == null) {
            resource = new CollectionResourceWrapper(date, 0, null, null, null, null, null, null);
        }
        if ((dsLabelValue = resource.getFieldValue(resource.getDsLabel())) == null) {
            dsLabelValue = UNKNOWN;
        }
        if ((exprLabelValue = (String)this.getThresholdConfig().getExprLabel().orElse(null)) == null) {
            exprLabelValue = "";
        }
        EventBuilder bldr = new EventBuilder(uei, "OpenNMS.Threshd." + this.getThresholdConfig().getDatasourceExpression(), date);
        bldr.setNodeid((long)resource.getNodeId());
        bldr.setService(resource.getServiceName());
        bldr.setInterface(InetAddressUtils.addr((String)resource.getHostAddress()));
        if (resource.isAnInterfaceResource() || resource.isLatencyResource()) {
            String ipaddr;
            if (UNKNOWN.equals(dsLabelValue)) {
                dsLabelValue = resource.getIfLabel();
            }
            bldr.addParam("ifLabel", resource.getIfLabel());
            if (resource.getIfIndex() != null) {
                bldr.addParam("ifIndex", resource.getIfIndex());
            }
            if ((ipaddr = resource.getIfInfoValue("ipaddr")) != null && !"0.0.0.0".equals(ipaddr)) {
                bldr.addParam("ifIpAddress", ipaddr);
            }
        }
        if (resource.isNodeResource() && UNKNOWN.equals(dsLabelValue)) {
            dsLabelValue = "node";
        }
        bldr.addParam("label", dsLabelValue);
        bldr.addParam("expressionLabel", exprLabelValue);
        bldr.setHost(InetAddressUtils.getLocalHostName());
        bldr.addParam("ds", this.getThresholdConfig().getDatasourceExpression());
        String descr = this.getThresholdConfig().getBasethresholddef().getDescription().orElseGet(() -> ((AbstractState)this.state).getInterpolatedExpression().orElse(this.getThresholdConfig().getDatasourceExpression()));
        bldr.addParam("description", descr);
        bldr.addParam("value", this.formatValue(dsValue));
        String defaultInstance = resource.isNodeResource() ? "node" : UNKNOWN;
        bldr.addParam("instance", resource.getInstance() == null ? defaultInstance : resource.getInstance());
        bldr.addParam("instanceLabel", resource.getInstanceLabel() == null ? defaultInstance : resource.getInstanceLabel());
        bldr.addParam("resourceType", resource.getResourceTypeName());
        ResourceId resourceId = resource.getResourceId();
        bldr.addParam("resourceId", resourceId != null ? resourceId.toString() : null);
        if (additionalParams != null) {
            for (String p : additionalParams.keySet()) {
                bldr.addParam(p, additionalParams.get(p));
            }
        }
        return bldr.getEvent();
    }

    protected String formatValue(double value) {
        if (Double.isNaN(value)) {
            return FORMATED_NAN;
        }
        String pattern = System.getProperty("org.opennms.threshd.value.decimalformat", "###.##");
        DecimalFormat valueFormatter = new DecimalFormat(pattern);
        return valueFormatter.format(value);
    }

    @Override
    public ThresholdingSession getThresholdingSession() {
        return this.thresholdingSession;
    }

    private boolean isDistributed() {
        return this.thresholdingSession.isDistributed();
    }

    @Override
    public void setInstance(String instance) {
        Objects.requireNonNull(instance);
        if (this.instance != null) {
            throw new IllegalStateException("Cannot apply instance " + instance + " since this evaluator state already has instance " + this.instance);
        }
        if (!this.firstEvaluation) {
            throw new IllegalStateException("This state has already been evaluated so changing the instance to " + instance + " won't have an effect");
        }
        this.instance = instance;
        this.key = String.format("%s-%s", this.key, instance);
    }

    @VisibleForTesting
    static void clearSerdesMap() {
        serdesMap.clear();
    }

    static {
        fst.registerClass(new Class[]{ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow.State.class, ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange.State.class, ThresholdEvaluatorRearmingAbsoluteChange.ThresholdEvaluatorStateRearmingAbsoluteChange.State.class, ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange.State.class});
        serdesMap = new ConcurrentHashMap<Class<? extends AbstractState>, SerializingBlobStore<? extends AbstractState>>();
        lastUpdatedCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Long>(){

            public Long load(String key) {
                return null;
            }
        }).asMap();
    }

    static abstract class AbstractState
    implements Serializable {
        String interpolatedExpression = null;
        boolean cached = false;
        ThresholdEvaluatorState.ThresholdValues thresholdValues = null;

        AbstractState() {
        }

        Optional<String> getInterpolatedExpression() {
            return Optional.ofNullable(this.interpolatedExpression);
        }

        void setInterpolatedExpression(String expression) {
            this.interpolatedExpression = Objects.requireNonNull(expression);
        }

        public void setCached(boolean cached) {
            this.cached = cached;
        }

        public boolean isCached() {
            return this.cached;
        }

        public ThresholdEvaluatorState.ThresholdValues getThresholdValues() {
            return this.thresholdValues;
        }

        public void setThresholdValues(ThresholdEvaluatorState.ThresholdValues thresholdValues) {
            this.thresholdValues = thresholdValues;
        }

        public String toString() {
            return this.getInterpolatedExpression().map(ie -> "interpolatedExpression=" + ie).orElse(null);
        }
    }
}

