/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.util.zip;

import io.pyroscope.javaagent.util.zip.Util;
import io.pyroscope.kotlin.jvm.internal.Intrinsics;
import io.pyroscope.okhttp3.MediaType;
import io.pyroscope.okhttp3.RequestBody;
import io.pyroscope.okio.Buffer;
import io.pyroscope.okio.BufferedSink;
import io.pyroscope.okio.DeflaterSink;
import io.pyroscope.okio.Okio;
import io.pyroscope.okio.Segment;
import io.pyroscope.okio.Sink;
import io.pyroscope.okio.Timeout;
import io.pyroscope.org.jetbrains.annotations.NotNull;
import io.pyroscope.org.jetbrains.annotations.Nullable;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public final class GzipSink
implements Sink {
    private final BufferedSink sink;
    @NotNull
    private final Deflater deflater;
    private final DeflaterSink deflaterSink;
    private boolean closed;
    private final CRC32 crc;

    public GzipSink(@NotNull Sink sink2, int compressionLevel) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        this.sink = Okio.buffer(sink2);
        this.deflater = new Deflater(compressionLevel, true);
        this.deflaterSink = new DeflaterSink(this.sink, this.deflater);
        this.crc = new CRC32();
        Buffer buf = this.sink.getBuffer();
        buf.writeShort(8075);
        buf.writeByte(8);
        buf.writeByte(0);
        buf.writeInt(0);
        buf.writeByte(0);
        buf.writeByte(0);
    }

    @Override
    public void write(@NotNull Buffer source2, long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (byteCount == 0L) {
            return;
        }
        this.updateCrc(source2, byteCount);
        this.deflaterSink.write(source2, byteCount);
    }

    @Override
    public void close() throws IOException {
        throw new IllegalStateException("should not be called. use end");
    }

    public void end() throws IOException {
        if (!this.closed) {
            Throwable thrown;
            block9: {
                block8: {
                    thrown = null;
                    try {
                        this.deflaterSink.finishDeflate$okio();
                        this.writeFooter();
                    }
                    catch (Throwable var3) {
                        thrown = var3;
                    }
                    try {
                        this.deflater.end();
                    }
                    catch (Throwable var5) {
                        if (thrown != null) break block8;
                        thrown = var5;
                    }
                }
                try {
                    this.sink.flush();
                }
                catch (Throwable var4) {
                    if (thrown != null) break block9;
                    thrown = var4;
                }
            }
            this.closed = true;
            if (thrown != null) {
                Util.sneakyRethrow(thrown);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.deflaterSink.flush();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.sink.timeout();
    }

    private void updateCrc(Buffer buffer, long byteCount) {
        int segmentLength;
        Segment head = buffer.head;
        Intrinsics.checkNotNull(head);
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)segmentLength) {
            segmentLength = (int)Math.min(remaining, (long)(head.limit - head.pos));
            this.crc.update(head.data, head.pos, segmentLength);
            head = head.next;
            Intrinsics.checkNotNull(head);
        }
    }

    private final void writeFooter() throws IOException {
        this.sink.writeIntLe((int)this.crc.getValue());
        this.sink.writeIntLe((int)this.deflater.getBytesRead());
    }

    public static RequestBody gzip(final RequestBody req, final int compressionLevel) {
        return new RequestBody(){

            @Override
            @Nullable
            public MediaType contentType() {
                return req.contentType();
            }

            @Override
            public long contentLength() throws IOException {
                return -1L;
            }

            @Override
            public void writeTo(@NotNull BufferedSink sink2) throws IOException {
                GzipSink gzipSink = new GzipSink(sink2, compressionLevel);
                BufferedSink buffer = Okio.buffer(gzipSink);
                req.writeTo(buffer);
                buffer.flush();
                gzipSink.end();
            }

            @Override
            public boolean isOneShot() {
                return req.isOneShot();
            }
        };
    }
}

