/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.shell;

import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.table.HAlign;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="opennms", name="pollerd-schedule", description="Displays the scheduled poller tasks.")
@Service
public class PollerdScheduleCommand
implements Action {
    @Option(name="-s", aliases={"--services"}, description="Show number of scheduled pollable services, 0 for all", required=false, multiValued=false)
    private Integer services = null;
    @Option(name="-o", aliases={"--order"}, description="Sort by given column", required=false, multiValued=false)
    private String order = "readyTimeAbsoluteMs";
    @Option(name="-c", aliases={"--columns"}, description="Comma-seperated list of columns to be displayed", required=false, multiValued=false)
    private String columns = null;
    @Option(name="-d", aliases={"--desc"}, description="Descending order", required=false, multiValued=false)
    private Boolean descendingOrder = false;
    @Option(name="--no-ellipsis", description="wrap table rows")
    boolean noEllipsis;
    @Reference(optional=true)
    Terminal terminal;
    final Map<String, ColumnDef> columnDefs = new LinkedHashMap<String, ColumnDef>();

    public PollerdScheduleCommand() {
        this.columnDefs.put("nodeId", new ColumnDef(Comparator.comparingInt(c -> (Integer)c.get("nodeId")), HAlign.right));
        this.columnDefs.put("nodeLabel", new ColumnDef(Comparator.comparing(c -> (String)c.get("nodeLabel")), HAlign.left));
        this.columnDefs.put("nodeLocation", new ColumnDef(Comparator.comparing(c -> (String)c.get("nodeLocation")), HAlign.left));
        this.columnDefs.put("ipAddress", new ColumnDef(Comparator.comparing(c -> (String)c.get("ipAddress")), HAlign.center));
        this.columnDefs.put("readyTimeMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("readyTimeMs")), HAlign.right));
        this.columnDefs.put("readyTimeAbsoluteMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("readyTimeAbsoluteMs")), HAlign.right));
        this.columnDefs.put("service", new ColumnDef(Comparator.comparing(c -> (String)c.get("service")), HAlign.center));
        this.columnDefs.put("status", new ColumnDef(Comparator.comparing(c -> (String)c.get("status")), HAlign.center));
        this.columnDefs.put("statusChangeTimeMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("statusChangeTimeMs")), HAlign.right));
    }

    private void printColumns() {
        System.out.printf("Column %s does not exist. Available columns are:\n", this.order);
        for (String columnName : this.columnDefs.keySet()) {
            System.out.printf("  %s\n", columnName);
        }
    }

    public Void execute() throws MalformedObjectNameException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName("OpenNMS:Name=Pollerd");
        String[] columnArr = this.columnDefs.keySet().toArray(new String[0]);
        if (!mBeanServer.isRegistered(objectName)) {
            System.out.println("Error accessing Pollerd mBean");
            return null;
        }
        if (!Strings.isNullOrEmpty((String)this.columns)) {
            if (this.services == null) {
                System.out.println("Option --columns/-c can only be used in combination with --schedule/-s.");
                return null;
            }
            if (!Strings.isNullOrEmpty((String)this.columns)) {
                String[] arr;
                for (String column : arr = this.columns.split(",")) {
                    if (this.columnDefs.keySet().contains(column)) continue;
                    this.printColumns();
                    return null;
                }
                columnArr = arr;
            }
        }
        if (this.services != null && !this.columnDefs.keySet().contains(this.order)) {
            this.printColumns();
            return null;
        }
        Long currentTimeMillis = null;
        System.out.printf("Active Threads: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "ActiveThreads")));
        System.out.printf("Num Polls: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "NumPolls")));
        System.out.printf("Core Pool Threads: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "CorePoolThreads")));
        System.out.printf("Max Pool Threads: %d\n", (Long)mBeanServer.getAttribute(objectName, "MaxPoolThreads"));
        System.out.printf("Num Pool Threads:%d \n", (long)((Long)mBeanServer.getAttribute(objectName, "NumPoolThreads")));
        System.out.printf("Peak Pool Threads: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "PeakPoolThreads")));
        System.out.printf("Task Completion Ratio: %,.5f\n", (double)((Double)mBeanServer.getAttribute(objectName, "TaskCompletionRatio")));
        System.out.printf("Task Queue Pending Count: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TaskQueuePendingCount")));
        System.out.printf("Task Queue Remaining Capacity: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TaskQueueRemainingCapacity")));
        System.out.printf("Tasks Completed: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TasksCompleted")));
        System.out.printf("Tasks Total: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TasksTotal")));
        if (this.services != null) {
            TabularData tabularData = (TabularData)mBeanServer.getAttribute(objectName, "Schedule");
            if (this.services < 0) {
                System.out.printf("\nOption --services/-s must be zero or positive.\n", new Object[0]);
                return null;
            }
            if (tabularData.isEmpty()) {
                System.out.printf("\nNo Pollerd scheduled services found\n", new Object[0]);
                return null;
            }
            ShellTable table = new ShellTable();
            if (!this.noEllipsis && this.terminal != null && this.terminal.getWidth() > 0) {
                table.size(this.terminal.getWidth() - 1);
            }
            for (String column : columnArr) {
                table.column(column).align(this.columnDefs.get((Object)column).alignment);
            }
            Comparator<CompositeData> compositeDataComparator = this.descendingOrder != false ? this.columnDefs.get((Object)this.order).comparator.reversed() : this.columnDefs.get((Object)this.order).comparator;
            Stream<CompositeData> compositeDataStream = tabularData.values().stream().sorted(compositeDataComparator);
            if (this.services > 0) {
                compositeDataStream = compositeDataStream.limit(this.services.intValue());
            }
            List compositeDataList = compositeDataStream.collect(Collectors.toList());
            for (CompositeData compositeData : compositeDataList) {
                if (currentTimeMillis == null) {
                    currentTimeMillis = (Long)compositeData.get("readyTimeAbsoluteMs") - (Long)compositeData.get("readyTimeMs");
                }
                Row row = table.addRow();
                for (String column : columnArr) {
                    row.addContent(new Object[]{compositeData.get(column)});
                }
            }
            System.out.printf("Current Time Millis: %d\n\n", currentTimeMillis);
            table.print(System.out);
        }
        return null;
    }

    private class ColumnDef {
        private final Comparator<CompositeData> comparator;
        private final HAlign alignment;

        public ColumnDef(Comparator<CompositeData> comparator, HAlign alignment) {
            this.comparator = comparator;
            this.alignment = alignment;
        }
    }
}

