/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka.server;

import org.opennms.core.ipc.sink.common.SinkStrategy;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={Condition.class})
@ImportResource(value={"/META-INF/opennms/applicationContext-ipc-offset-provider.xml"})
public class ConditionalKafkaOffsetContext {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalKafkaOffsetContext.class);

    static class Condition
    implements ConfigurationCondition {
        Condition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean kafkaSinkEnabled = SinkStrategy.Strategy.KAFKA.equals((Object)SinkStrategy.getSinkStrategy());
            if (!kafkaSinkEnabled) {
                return false;
            }
            boolean disabled = Boolean.getBoolean("org.opennms.core.ipc.sink.kafka.offset.disabled");
            if (!disabled) {
                disabled = Boolean.getBoolean("org.opennms.core.ipc.kafka.offset.disabled");
            }
            boolean offsetEnabled = !disabled;
            try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
                if (offsetEnabled) {
                    LOG.debug("Kafka offset provider is enabled.");
                } else {
                    LOG.debug("Kafka offset provider is disabled.");
                }
            }
            return offsetEnabled;
        }
    }
}

