/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnResetEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerMetrics;
import io.github.resilience4j.circuitbreaker.internal.SchedulerFactory;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CircuitBreakerStateMachine
implements CircuitBreaker {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerStateMachine.class);
    private final String name;
    private final AtomicReference<CircuitBreakerState> stateReference;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CircuitBreakerEventProcessor eventProcessor;
    private final Clock clock;
    private final SchedulerFactory schedulerFactory;

    private CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, Clock clock, SchedulerFactory schedulerFactory) {
        this.name = name;
        this.circuitBreakerConfig = Objects.requireNonNull(circuitBreakerConfig, "Config must not be null");
        this.stateReference = new AtomicReference<ClosedState>(new ClosedState());
        this.eventProcessor = new CircuitBreakerEventProcessor();
        this.clock = clock;
        this.schedulerFactory = schedulerFactory;
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, SchedulerFactory schedulerFactory) {
        this(name, circuitBreakerConfig, Clock.systemUTC(), schedulerFactory);
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, Clock clock) {
        this(name, circuitBreakerConfig, clock, SchedulerFactory.getInstance());
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig) {
        this(name, circuitBreakerConfig, Clock.systemUTC());
    }

    public CircuitBreakerStateMachine(String name) {
        this(name, CircuitBreakerConfig.ofDefaults());
    }

    public CircuitBreakerStateMachine(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfig) {
        this(name, circuitBreakerConfig.get());
    }

    @Override
    public boolean tryAcquirePermission() {
        boolean callPermitted = this.stateReference.get().tryAcquirePermission();
        if (!callPermitted) {
            this.publishCallNotPermittedEvent();
        }
        return callPermitted;
    }

    @Override
    public void releasePermission() {
        this.stateReference.get().releasePermission();
    }

    @Override
    public void acquirePermission() {
        try {
            this.stateReference.get().acquirePermission();
        }
        catch (Exception e) {
            this.publishCallNotPermittedEvent();
            throw e;
        }
    }

    @Override
    public void onError(long durationInNanos, Throwable throwable) {
        Predicate<Throwable> recordFailurePredicate = this.circuitBreakerConfig.getRecordFailurePredicate();
        if (throwable instanceof CompletionException) {
            Throwable cause = throwable.getCause();
            this.handleThrowable(durationInNanos, recordFailurePredicate, cause);
        } else {
            this.handleThrowable(durationInNanos, recordFailurePredicate, throwable);
        }
    }

    private void handleThrowable(long durationInNanos, Predicate<Throwable> recordFailurePredicate, Throwable throwable) {
        if (recordFailurePredicate.test(throwable)) {
            LOG.debug("CircuitBreaker '{}' recorded a failure:", (Object)this.name, (Object)throwable);
            this.publishCircuitErrorEvent(this.name, durationInNanos, throwable);
            this.stateReference.get().onError(throwable);
        } else {
            this.releasePermission();
            this.publishCircuitIgnoredErrorEvent(this.name, durationInNanos, throwable);
        }
    }

    @Override
    public void onSuccess(long durationInNanos) {
        this.publishSuccessEvent(durationInNanos);
        this.stateReference.get().onSuccess();
    }

    @Override
    public CircuitBreaker.State getState() {
        return this.stateReference.get().getState();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    @Override
    public CircuitBreaker.Metrics getMetrics() {
        return this.stateReference.get().getMetrics();
    }

    public String toString() {
        return String.format("CircuitBreaker '%s'", this.name);
    }

    @Override
    public void reset() {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> new ClosedState());
        if (previousState.getState() != CircuitBreaker.State.CLOSED) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionBetween(previousState.getState(), CircuitBreaker.State.CLOSED));
        }
        this.publishResetEvent();
    }

    private void stateTransition(CircuitBreaker.State newState, UnaryOperator<CircuitBreakerState> newStateGenerator) {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> {
            if (currentState.getState() == newState) {
                return currentState;
            }
            return (CircuitBreakerState)newStateGenerator.apply((CircuitBreakerState)currentState);
        });
        if (previousState.getState() != newState) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionBetween(previousState.getState(), newState));
        }
    }

    @Override
    public void transitionToDisabledState() {
        this.stateTransition(CircuitBreaker.State.DISABLED, currentState -> new DisabledState());
    }

    @Override
    public void transitionToForcedOpenState() {
        this.stateTransition(CircuitBreaker.State.FORCED_OPEN, currentState -> new ForcedOpenState());
    }

    @Override
    public void transitionToClosedState() {
        this.stateTransition(CircuitBreaker.State.CLOSED, currentState -> new ClosedState(currentState.getMetrics()));
    }

    @Override
    public void transitionToOpenState() {
        this.stateTransition(CircuitBreaker.State.OPEN, currentState -> new OpenState(currentState.getMetrics()));
    }

    @Override
    public void transitionToHalfOpenState() {
        this.stateTransition(CircuitBreaker.State.HALF_OPEN, currentState -> new HalfOpenState());
    }

    private boolean shouldPublishEvents(CircuitBreakerEvent event) {
        return this.stateReference.get().shouldPublishEvents(event);
    }

    private void publishEventIfPossible(CircuitBreakerEvent event) {
        if (this.shouldPublishEvents(event)) {
            if (this.eventProcessor.hasConsumers()) {
                LOG.debug("Event {} published: {}", (Object)event.getEventType(), (Object)event);
                try {
                    this.eventProcessor.consumeEvent(event);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to handle event {}", (Object)event.getEventType(), (Object)t);
                }
            } else {
                LOG.debug("No Consumers: Event {} not published", (Object)event.getEventType());
            }
        } else {
            LOG.debug("Publishing not allowed: Event {} not published", (Object)event.getEventType());
        }
    }

    private void publishStateTransitionEvent(CircuitBreaker.StateTransition stateTransition) {
        CircuitBreakerOnStateTransitionEvent event = new CircuitBreakerOnStateTransitionEvent(this.name, stateTransition);
        this.publishEventIfPossible(event);
    }

    private void publishResetEvent() {
        CircuitBreakerOnResetEvent event = new CircuitBreakerOnResetEvent(this.name);
        this.publishEventIfPossible(event);
    }

    private void publishCallNotPermittedEvent() {
        CircuitBreakerOnCallNotPermittedEvent event = new CircuitBreakerOnCallNotPermittedEvent(this.name);
        this.publishEventIfPossible(event);
    }

    private void publishSuccessEvent(long durationInNanos) {
        CircuitBreakerOnSuccessEvent event = new CircuitBreakerOnSuccessEvent(this.name, Duration.ofNanos(durationInNanos));
        this.publishEventIfPossible(event);
    }

    private void publishCircuitErrorEvent(String name, long durationInNanos, Throwable throwable) {
        CircuitBreakerOnErrorEvent event = new CircuitBreakerOnErrorEvent(name, Duration.ofNanos(durationInNanos), throwable);
        this.publishEventIfPossible(event);
    }

    private void publishCircuitIgnoredErrorEvent(String name, long durationInNanos, Throwable throwable) {
        CircuitBreakerOnIgnoredErrorEvent event = new CircuitBreakerOnIgnoredErrorEvent(name, Duration.ofNanos(durationInNanos), throwable);
        this.publishEventIfPossible(event);
    }

    @Override
    public CircuitBreaker.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    private static interface CircuitBreakerState {
        public boolean tryAcquirePermission();

        public void acquirePermission();

        public void releasePermission();

        public void onError(Throwable var1);

        public void onSuccess();

        public CircuitBreaker.State getState();

        public CircuitBreakerMetrics getMetrics();

        default public boolean shouldPublishEvents(CircuitBreakerEvent event) {
            return event.getEventType().forcePublish || this.getState().allowPublish;
        }
    }

    private class HalfOpenState
    implements CircuitBreakerState {
        private CircuitBreakerMetrics circuitBreakerMetrics;
        private final float failureRateThreshold;
        private final AtomicInteger testRequestCounter;

        HalfOpenState() {
            this.circuitBreakerMetrics = new CircuitBreakerMetrics(CircuitBreakerStateMachine.this.circuitBreakerConfig.getRingBufferSizeInHalfOpenState());
            this.failureRateThreshold = CircuitBreakerStateMachine.this.circuitBreakerConfig.getFailureRateThreshold();
            this.testRequestCounter = new AtomicInteger(CircuitBreakerStateMachine.this.circuitBreakerConfig.getRingBufferSizeInHalfOpenState());
        }

        @Override
        public boolean tryAcquirePermission() {
            if (this.testRequestCounter.getAndUpdate(current -> current == 0 ? current : --current) > 0) {
                return true;
            }
            this.circuitBreakerMetrics.onCallNotPermitted();
            return false;
        }

        @Override
        public void acquirePermission() {
            if (!this.tryAcquirePermission()) {
                throw new CallNotPermittedException(CircuitBreakerStateMachine.this);
            }
        }

        @Override
        public void releasePermission() {
            this.testRequestCounter.incrementAndGet();
        }

        @Override
        public void onError(Throwable throwable) {
            this.checkFailureRate(this.circuitBreakerMetrics.onError());
        }

        @Override
        public void onSuccess() {
            this.checkFailureRate(this.circuitBreakerMetrics.onSuccess());
        }

        private void checkFailureRate(float currentFailureRate) {
            if (currentFailureRate != -1.0f) {
                if (currentFailureRate >= this.failureRateThreshold) {
                    CircuitBreakerStateMachine.this.transitionToOpenState();
                } else {
                    CircuitBreakerStateMachine.this.transitionToClosedState();
                }
            }
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.HALF_OPEN;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class ForcedOpenState
    implements CircuitBreakerState {
        private final CircuitBreakerMetrics circuitBreakerMetrics;

        ForcedOpenState() {
            int size = CircuitBreakerStateMachine.this.circuitBreakerConfig.getRingBufferSizeInHalfOpenState();
            this.circuitBreakerMetrics = new CircuitBreakerMetrics(size);
        }

        @Override
        public boolean tryAcquirePermission() {
            this.circuitBreakerMetrics.onCallNotPermitted();
            return false;
        }

        @Override
        public void acquirePermission() {
            this.circuitBreakerMetrics.onCallNotPermitted();
            throw new CallNotPermittedException(CircuitBreakerStateMachine.this);
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onSuccess() {
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.FORCED_OPEN;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class DisabledState
    implements CircuitBreakerState {
        private final CircuitBreakerMetrics circuitBreakerMetrics;

        DisabledState() {
            int size = CircuitBreakerStateMachine.this.circuitBreakerConfig.getRingBufferSizeInClosedState();
            this.circuitBreakerMetrics = new CircuitBreakerMetrics(size);
        }

        @Override
        public boolean tryAcquirePermission() {
            return true;
        }

        @Override
        public void acquirePermission() {
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onSuccess() {
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.DISABLED;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class OpenState
    implements CircuitBreakerState {
        private final Instant retryAfterWaitDuration;
        private final CircuitBreakerMetrics circuitBreakerMetrics;

        OpenState(CircuitBreakerMetrics circuitBreakerMetrics) {
            Duration waitDurationInOpenState = CircuitBreakerStateMachine.this.circuitBreakerConfig.getWaitDurationInOpenState();
            this.retryAfterWaitDuration = CircuitBreakerStateMachine.this.clock.instant().plus(waitDurationInOpenState);
            this.circuitBreakerMetrics = circuitBreakerMetrics;
            if (CircuitBreakerStateMachine.this.circuitBreakerConfig.isAutomaticTransitionFromOpenToHalfOpenEnabled()) {
                ScheduledExecutorService scheduledExecutorService = CircuitBreakerStateMachine.this.schedulerFactory.getScheduler();
                scheduledExecutorService.schedule(CircuitBreakerStateMachine.this::transitionToHalfOpenState, waitDurationInOpenState.toMillis(), TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public boolean tryAcquirePermission() {
            if (CircuitBreakerStateMachine.this.clock.instant().isAfter(this.retryAfterWaitDuration)) {
                CircuitBreakerStateMachine.this.transitionToHalfOpenState();
                return true;
            }
            this.circuitBreakerMetrics.onCallNotPermitted();
            return false;
        }

        @Override
        public void acquirePermission() {
            if (!this.tryAcquirePermission()) {
                throw new CallNotPermittedException(CircuitBreakerStateMachine.this);
            }
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(Throwable throwable) {
            this.circuitBreakerMetrics.onError();
        }

        @Override
        public void onSuccess() {
            this.circuitBreakerMetrics.onSuccess();
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.OPEN;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class ClosedState
    implements CircuitBreakerState {
        private final CircuitBreakerMetrics circuitBreakerMetrics;
        private final float failureRateThreshold;

        ClosedState() {
            this(null);
        }

        ClosedState(CircuitBreakerMetrics circuitBreakerMetrics) {
            this.circuitBreakerMetrics = circuitBreakerMetrics == null ? new CircuitBreakerMetrics(CircuitBreakerStateMachine.this.circuitBreakerConfig.getRingBufferSizeInClosedState()) : circuitBreakerMetrics.copy(CircuitBreakerStateMachine.this.circuitBreakerConfig.getRingBufferSizeInClosedState());
            this.failureRateThreshold = CircuitBreakerStateMachine.this.circuitBreakerConfig.getFailureRateThreshold();
        }

        @Override
        public boolean tryAcquirePermission() {
            return true;
        }

        @Override
        public void acquirePermission() {
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(Throwable throwable) {
            this.checkFailureRate(this.circuitBreakerMetrics.onError());
        }

        @Override
        public void onSuccess() {
            this.checkFailureRate(this.circuitBreakerMetrics.onSuccess());
        }

        private void checkFailureRate(float currentFailureRate) {
            if (currentFailureRate >= this.failureRateThreshold) {
                CircuitBreakerStateMachine.this.transitionToOpenState();
            }
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.CLOSED;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class CircuitBreakerEventProcessor
    extends EventProcessor<CircuitBreakerEvent>
    implements EventConsumer<CircuitBreakerEvent>,
    CircuitBreaker.EventPublisher {
        private CircuitBreakerEventProcessor() {
        }

        @Override
        public CircuitBreaker.EventPublisher onSuccess(EventConsumer<CircuitBreakerOnSuccessEvent> onSuccessEventConsumer) {
            this.registerConsumer(CircuitBreakerOnSuccessEvent.class.getSimpleName(), onSuccessEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onError(EventConsumer<CircuitBreakerOnErrorEvent> onErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnErrorEvent.class.getSimpleName(), onErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onStateTransition(EventConsumer<CircuitBreakerOnStateTransitionEvent> onStateTransitionEventConsumer) {
            this.registerConsumer(CircuitBreakerOnStateTransitionEvent.class.getSimpleName(), onStateTransitionEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onReset(EventConsumer<CircuitBreakerOnResetEvent> onResetEventConsumer) {
            this.registerConsumer(CircuitBreakerOnResetEvent.class.getSimpleName(), onResetEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onIgnoredError(EventConsumer<CircuitBreakerOnIgnoredErrorEvent> onIgnoredErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnIgnoredErrorEvent.class.getSimpleName(), onIgnoredErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onCallNotPermitted(EventConsumer<CircuitBreakerOnCallNotPermittedEvent> onCallNotPermittedEventConsumer) {
            this.registerConsumer(CircuitBreakerOnCallNotPermittedEvent.class.getSimpleName(), onCallNotPermittedEventConsumer);
            return this;
        }

        public void consumeEvent(CircuitBreakerEvent event) {
            super.processEvent((Object)event);
        }
    }
}

