/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="ospfElement")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public final class OspfElement
implements Serializable {
    private static final long serialVersionUID = 7820026592390162672L;
    private Integer m_id;
    private InetAddress m_ospfRouterId;
    private Status m_ospfAdminStat;
    private Integer m_ospfVersionNumber;
    private TruthValue m_ospfBdrRtrStatus;
    private TruthValue m_ospfASBdrRtrStatus;
    private InetAddress m_ospfRouterIdNetmask;
    private Integer m_ospfRouterIdIfindex;
    private Date m_ospfNodeCreateTime = new Date();
    private Date m_ospfNodeLastPollTime;
    private OnmsNode m_node;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @Column(name="ospfRouterId", nullable=false)
    public InetAddress getOspfRouterId() {
        return this.m_ospfRouterId;
    }

    @Column(name="ospfAdminStat", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.StatusUserType")
    public Status getOspfAdminStat() {
        return this.m_ospfAdminStat;
    }

    @Column(name="ospfVersionNumber", nullable=false)
    public Integer getOspfVersionNumber() {
        return this.m_ospfVersionNumber;
    }

    @Column(name="ospfBdrRtrStatus", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.TruthValueUserType")
    public TruthValue getOspfBdrRtrStatus() {
        return this.m_ospfBdrRtrStatus;
    }

    @Column(name="ospfASBdrRtrStatus", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.TruthValueUserType")
    public TruthValue getOspfASBdrRtrStatus() {
        return this.m_ospfASBdrRtrStatus;
    }

    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @Column(name="ospfRouterIdNetmask", nullable=false)
    public InetAddress getOspfRouterIdNetmask() {
        return this.m_ospfRouterIdNetmask;
    }

    @Column(name="ospfRouterIdIfindex", nullable=false)
    public Integer getOspfRouterIdIfindex() {
        return this.m_ospfRouterIdIfindex;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ospfNodeCreateTime", nullable=false)
    public Date getOspfNodeCreateTime() {
        return this.m_ospfNodeCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ospfNodeLastPollTime", nullable=false)
    public Date getOspfNodeLastPollTime() {
        return this.m_ospfNodeLastPollTime;
    }

    public void setOspfRouterId(InetAddress ospfRouterId) {
        this.m_ospfRouterId = ospfRouterId;
    }

    public void setOspfAdminStat(Status ospfAdminStat) {
        this.m_ospfAdminStat = ospfAdminStat;
    }

    public void setOspfVersionNumber(Integer ospfVersionNumber) {
        this.m_ospfVersionNumber = ospfVersionNumber;
    }

    public void setOspfBdrRtrStatus(TruthValue ospfBdrRtrStatus) {
        this.m_ospfBdrRtrStatus = ospfBdrRtrStatus;
    }

    public void setOspfASBdrRtrStatus(TruthValue ospfASBdrRtrStatus) {
        this.m_ospfASBdrRtrStatus = ospfASBdrRtrStatus;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public void setOspfRouterIdNetmask(InetAddress ospfRouterIdNetmask) {
        this.m_ospfRouterIdNetmask = ospfRouterIdNetmask;
    }

    public void setOspfRouterIdIfindex(Integer ospfRouterIdIfindex) {
        this.m_ospfRouterIdIfindex = ospfRouterIdIfindex;
    }

    public void setOspfNodeCreateTime(Date ospfNodeCreateTime) {
        this.m_ospfNodeCreateTime = ospfNodeCreateTime;
    }

    public void setOspfNodeLastPollTime(Date ospfNodeLastPollTime) {
        this.m_ospfNodeLastPollTime = ospfNodeLastPollTime;
    }

    public String toString() {
        return "ospfelement: nodeid:[" + this.getNode().getId() + "]: version:[" + this.getOspfVersionNumber() + "]: status:[" + Status.getTypeString(this.getOspfAdminStat().getValue()) + "]: id/mask/ifindex:[" + InetAddressUtils.str((InetAddress)this.getOspfRouterId()) + "/" + InetAddressUtils.str((InetAddress)this.getOspfRouterIdNetmask()) + "/" + this.getOspfRouterIdIfindex() + "]: Border Router Status:[" + TruthValue.getTypeString(this.getOspfBdrRtrStatus().getValue()) + "]: AS Border Router Status:[" + TruthValue.getTypeString(this.getOspfASBdrRtrStatus().getValue()) + "]";
    }

    public void merge(OspfElement element) {
        if (element == null) {
            return;
        }
        this.setOspfRouterId(element.getOspfRouterId());
        this.setOspfRouterIdIfindex(element.getOspfRouterIdIfindex());
        this.setOspfRouterIdNetmask(element.getOspfRouterIdNetmask());
        this.setOspfAdminStat(element.getOspfAdminStat());
        this.setOspfASBdrRtrStatus(element.getOspfASBdrRtrStatus());
        this.setOspfBdrRtrStatus(element.getOspfASBdrRtrStatus());
        this.setOspfNodeLastPollTime(element.getOspfNodeCreateTime());
    }

    public static enum Status {
        enabled(1),
        disabled(2);

        private final int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private Status(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static Status get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create Status from null code");
            }
            switch (code) {
                case 1: {
                    return enabled;
                }
                case 2: {
                    return disabled;
                }
            }
            throw new IllegalArgumentException("Cannot create Status from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "enabled");
            s_typeMap.put(2, "disabled");
        }
    }

    public static enum TruthValue {
        TRUE(1),
        FALSE(2);

        private final int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private TruthValue(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static TruthValue get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create TruthValue from null code");
            }
            switch (code) {
                case 1: {
                    return TRUE;
                }
                case 2: {
                    return FALSE;
                }
            }
            throw new IllegalArgumentException("Cannot create TruthValue from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "true");
            s_typeMap.put(2, "false");
        }
    }
}

