/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import com.google.common.base.MoreObjects;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.model.ReadOnlyEntity;
import org.springframework.util.Assert;

@ReadOnlyEntity
public class LldpLinkTopologyEntity {
    private final Integer id;
    private final Integer nodeId;
    private final String lldpRemChassisId;
    private final String lldpRemSysname;
    private final String lldpRemPortId;
    private final String lldpRemPortDescr;
    private final LldpUtils.LldpPortIdSubType lldpRemPortIdSubType;
    private final String lldpPortId;
    private final LldpUtils.LldpPortIdSubType lldpPortIdSubType;
    private final String lldpPortDescr;
    private final Integer lldpPortIfindex;

    public LldpLinkTopologyEntity(Integer id, Integer nodeId, String lldpRemChassisId, String lldpRemSysname, String lldpRemPortId, LldpUtils.LldpPortIdSubType lldpRemPortIdSubType, String remportdescr, String lldpPortId, LldpUtils.LldpPortIdSubType lldpPortIdSubType, String lldpPortDescr, Integer lldpPortIfindex) {
        Assert.notNull((Object)remportdescr);
        this.id = id;
        this.nodeId = nodeId;
        this.lldpRemChassisId = lldpRemChassisId;
        this.lldpRemSysname = lldpRemSysname;
        this.lldpRemPortId = lldpRemPortId;
        this.lldpRemPortIdSubType = lldpRemPortIdSubType;
        this.lldpPortId = lldpPortId;
        this.lldpRemPortDescr = remportdescr;
        this.lldpPortIdSubType = lldpPortIdSubType;
        this.lldpPortDescr = lldpPortDescr;
        this.lldpPortIfindex = lldpPortIfindex;
    }

    public static LldpLinkTopologyEntity create(LldpLink link) {
        return new LldpLinkTopologyEntity(link.getId(), link.getNode().getId(), link.getLldpRemChassisId(), link.getLldpRemSysname(), link.getLldpRemPortId(), link.getLldpRemPortIdSubType(), link.getLldpPortDescr(), link.getLldpPortId(), link.getLldpPortIdSubType(), link.getLldpPortDescr(), link.getLldpPortIfindex());
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }

    public String getLldpRemChassisId() {
        return this.lldpRemChassisId;
    }

    public String getLldpRemPortId() {
        return this.lldpRemPortId;
    }

    public LldpUtils.LldpPortIdSubType getLldpRemPortIdSubType() {
        return this.lldpRemPortIdSubType;
    }

    public String getLldpPortId() {
        return this.lldpPortId;
    }

    public LldpUtils.LldpPortIdSubType getLldpPortIdSubType() {
        return this.lldpPortIdSubType;
    }

    public String getLldpPortDescr() {
        return this.lldpPortDescr;
    }

    public Integer getLldpPortIfindex() {
        return this.lldpPortIfindex;
    }

    public String getLldpRemPortDescr() {
        return this.lldpRemPortDescr;
    }

    public String getLldpRemSysname() {
        return this.lldpRemSysname;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("nodeId", (Object)this.nodeId).add("lldpRemChassisId", (Object)this.lldpRemChassisId).add("lldpRemSysname", (Object)this.lldpRemSysname).add("lldpRemPortId", (Object)this.lldpRemPortId).add("lldpRemPortIdSubType", (Object)this.lldpRemPortIdSubType).add("lldpRemPortDescr", (Object)this.lldpRemPortDescr).add("lldpPortId", (Object)this.lldpPortId).add("lldpPortIdSubType", (Object)this.lldpPortIdSubType).add("lldpPortDescr", (Object)this.lldpPortDescr).add("lldpPortIfindex", (Object)this.lldpPortIfindex).toString();
    }
}

