/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing.impl;

import com.google.common.base.Strings;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.opennms.core.fileutils.FileUpdateWatcher;
import org.opennms.netmgt.flows.processing.enrichment.EnrichedFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMangler {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentMangler.class);
    private static final Logger RL_LOG = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private final ScriptEngineManager sem;
    private Path path;
    private FileUpdateWatcher watcher;
    private CompiledScript script;

    public DocumentMangler(ScriptEngineManager sem) {
        this.sem = Objects.requireNonNull(sem);
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) throws IOException {
        this.path = path;
        if (this.path != null) {
            if (Files.exists(this.path, new LinkOption[0])) {
                this.watcher = new FileUpdateWatcher(this.path.toAbsolutePath().toString(), this::reload);
                this.reload();
                return;
            }
            LOG.warn("Flow mangle script not found: {}", (Object)this.path.toString());
        }
        this.watcher = null;
        this.script = null;
    }

    public void setPath(String path) throws IOException {
        this.setPath(Strings.isNullOrEmpty((String)path) ? null : Paths.get(path, new String[0]));
    }

    private void reload() {
        LOG.info("Loading flow mangle script: {}", (Object)this.path);
        String ext = com.google.common.io.Files.getFileExtension((String)this.path.toString());
        LOG.debug("Searching engine for file extension {}", (Object)ext);
        ScriptEngine engine = this.sem.getEngineByExtension(ext);
        if (engine == null) {
            LOG.error("No engine found for extension: {}", (Object)ext);
            this.script = null;
            return;
        }
        LOG.debug("Using engine: {}", engine.getClass());
        if (!(engine instanceof Compilable)) {
            LOG.error("Only engines that can compile scripts are supported");
            this.script = null;
            return;
        }
        Compilable compilable = (Compilable)((Object)engine);
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            this.script = compilable.compile(reader);
        }
        catch (IOException | ScriptException e) {
            LOG.error("Failed to load script", (Throwable)e);
            this.script = null;
            return;
        }
        LOG.info("Script loaded successfully");
    }

    public EnrichedFlow mangle(EnrichedFlow flow) {
        if (this.script == null) {
            return flow;
        }
        try {
            SimpleBindings globals = new SimpleBindings();
            globals.put("flow", (Object)flow);
            Object result = this.script.eval(globals);
            if (result == null) {
                return null;
            }
            if (result instanceof EnrichedFlow) {
                return (EnrichedFlow)result;
            }
            RL_LOG.error("Mangle script returns garbage: {}", result.getClass());
            return null;
        }
        catch (ScriptException e) {
            RL_LOG.error("Failed to execute mangle script", (Throwable)e);
            return null;
        }
    }

    public void destroy() {
        if (this.watcher != null) {
            this.watcher.destroy();
        }
    }
}

