/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.config.api.EventdConfig;
import org.opennms.netmgt.dao.api.EventExpander;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.EventWrapper;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcBroadcaster;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.events.api.EventWriter;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.ImmutableEvent;
import org.opennms.netmgt.events.api.model.ImmutableMapper;
import org.opennms.netmgt.model.EventConfEvent;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class MockEventIpcManager
implements EventForwarder,
EventProxy,
EventIpcManager,
EventIpcBroadcaster {
    private static final Logger LOG = LoggerFactory.getLogger(MockEventIpcManager.class);
    private static final AtomicLong m_eventId = new AtomicLong();
    private EventAnticipator m_anticipator;
    private EventWriter m_eventWriter = new EventWriter(){

        public void writeEvent(org.opennms.netmgt.xml.event.Event e) {
            e.setDbid(Long.valueOf(m_eventId.incrementAndGet()));
        }
    };
    private List<ListenerKeeper> m_listeners = new ArrayList<ListenerKeeper>();
    private AtomicInteger m_pendingEvents = new AtomicInteger();
    private volatile int m_eventDelay = 20;
    private boolean m_synchronous = true;
    private ScheduledExecutorService m_scheduler = null;
    private EventExpander m_expander = null;
    private SendNowHook m_sendNowHook;
    private int m_numSchedulerThreads = 1;

    public MockEventIpcManager() {
        this.m_anticipator = new EventAnticipator();
    }

    public void addEventListener(EventListener listener) {
        this.m_listeners.add(new ListenerKeeper(listener, null));
    }

    public void addEventListener(EventListener listener, Collection<String> ueis) {
        this.m_listeners.add(new ListenerKeeper(listener, new HashSet<String>(ueis)));
    }

    public void addEventListener(EventListener listener, String uei) {
        this.m_listeners.add(new ListenerKeeper(listener, Collections.singleton(uei)));
    }

    public int getEventListenerCount() {
        return this.m_listeners.size();
    }

    public void broadcastNow(org.opennms.netmgt.xml.event.Event event) {
        this.broadcastNow(event, false);
    }

    public void broadcastNow(org.opennms.netmgt.xml.event.Event event, boolean synchronous) {
        LOG.debug("Sending: {}", (Object)new EventWrapper(event));
        ArrayList<ListenerKeeper> listeners = new ArrayList<ListenerKeeper>(this.m_listeners);
        ImmutableEvent immutableEvent = ImmutableMapper.fromMutableEvent((org.opennms.netmgt.xml.event.Event)event);
        for (ListenerKeeper k : listeners) {
            k.sendEventIfAppropriate((IEvent)immutableEvent);
        }
    }

    public void setEventWriter(EventWriter eventWriter) {
        this.m_eventWriter = eventWriter;
    }

    public EventAnticipator getEventAnticipator() {
        return this.m_anticipator;
    }

    public void setEventExpander(EventExpander expander) {
        this.m_expander = expander;
    }

    public void setEventAnticipator(EventAnticipator anticipator) {
        this.m_anticipator = anticipator;
    }

    public void removeEventListener(EventListener listener) {
        this.m_listeners.remove(new ListenerKeeper(listener, null));
    }

    public void removeEventListener(EventListener listener, Collection<String> ueis) {
        this.m_listeners.remove(new ListenerKeeper(listener, new HashSet<String>(ueis)));
    }

    public void removeEventListener(EventListener listener, String uei) {
        this.m_listeners.remove(new ListenerKeeper(listener, Collections.singleton(uei)));
    }

    public synchronized void setEventDelay(int millis) {
        this.m_eventDelay = millis;
    }

    public void sendEventToListeners(org.opennms.netmgt.xml.event.Event event) {
        this.m_eventWriter.writeEvent(event);
        this.broadcastNow(event, false);
    }

    public void setSynchronous(boolean syncState) {
        this.m_synchronous = syncState;
    }

    public boolean isSynchronous() {
        return this.m_synchronous;
    }

    public void setSendNowHook(SendNowHook hook) {
        this.m_sendNowHook = hook;
    }

    public SendNowHook getSendNowHook() {
        return this.m_sendNowHook;
    }

    public void setNumSchedulerThreads(int numThreads) {
        this.m_numSchedulerThreads = numThreads;
    }

    public int getNumSchedulerTheads() {
        return this.m_numSchedulerThreads;
    }

    public void sendNow(org.opennms.netmgt.xml.event.Event event) {
        this.sendNow(event, this.isSynchronous());
    }

    public synchronized void sendNow(final org.opennms.netmgt.xml.event.Event event, final boolean synchronous) {
        if (this.m_expander != null) {
            this.m_expander.expandEvent(event);
        }
        this.m_pendingEvents.incrementAndGet();
        LOG.debug("StartEvent processing ({} remaining)", (Object)this.m_pendingEvents);
        LOG.debug("Received: {}", (Object)new EventWrapper(event));
        this.m_anticipator.eventReceived(event);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (MockEventIpcManager.this.m_sendNowHook != null) {
                        MockEventIpcManager.this.m_sendNowHook.beforeBroadcast(event);
                    }
                    MockEventIpcManager.this.m_eventWriter.writeEvent(event);
                    MockEventIpcManager.this.broadcastNow(event, synchronous);
                    MockEventIpcManager.this.m_anticipator.eventProcessed(event);
                }
                finally {
                    MockEventIpcManager mockEventIpcManager = MockEventIpcManager.this;
                    synchronized (mockEventIpcManager) {
                        MockEventIpcManager.this.m_pendingEvents.decrementAndGet();
                        LOG.debug("Finished processing event ({} remaining)", (Object)MockEventIpcManager.this.m_pendingEvents);
                        MockEventIpcManager.this.notifyAll();
                    }
                    if (MockEventIpcManager.this.m_sendNowHook != null) {
                        MockEventIpcManager.this.m_sendNowHook.afterBroadcast(event);
                    }
                }
            }
        };
        if (synchronous) {
            r.run();
        } else {
            this.getScheduler().schedule(r, (long)this.m_eventDelay, TimeUnit.MILLISECONDS);
        }
    }

    ScheduledExecutorService getScheduler() {
        if (this.m_scheduler == null) {
            this.m_scheduler = Executors.newScheduledThreadPool(this.getNumSchedulerTheads(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), this.getNumSchedulerTheads()));
        }
        return this.m_scheduler;
    }

    public void sendNow(Log eventLog) {
        for (org.opennms.netmgt.xml.event.Event event : eventLog.getEvents().getEventCollection()) {
            this.sendNow(event);
        }
    }

    public void sendNowSync(org.opennms.netmgt.xml.event.Event event) {
        this.sendNow(event, true);
    }

    public void sendNowSync(Log eventLog) {
        for (org.opennms.netmgt.xml.event.Event event : eventLog.getEvents().getEventCollection()) {
            this.sendNow(event, true);
        }
    }

    public synchronized void finishProcessingEvents() {
        if (this.m_sendNowHook != null) {
            this.m_sendNowHook.finishProcessingEvents();
        }
        while (this.m_pendingEvents.get() > 0) {
            LOG.debug("Waiting for event processing: ({} remaining)", (Object)this.m_pendingEvents);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public EventdConfig getEventdConfig() {
        return null;
    }

    public void setEventdConfig(EventdConfig eventdConfig) {
    }

    public void setDataSource(DataSource instance) {
    }

    public void reset() {
        this.m_listeners = new ArrayList<ListenerKeeper>();
        this.m_anticipator.reset();
    }

    public void send(org.opennms.netmgt.xml.event.Event event) throws EventProxyException {
        this.sendNow(event);
    }

    public void send(Log eventLog) throws EventProxyException {
        this.sendNow(eventLog);
    }

    public boolean hasEventListener(String uei) {
        for (ListenerKeeper keeper : this.m_listeners) {
            if (!keeper.m_ueiList.contains(uei)) continue;
            return true;
        }
        return false;
    }

    public static void setEventIdStart(long l) {
        m_eventId.set(l);
    }

    static class ListenerKeeper {
        final EventListener m_listener;
        final Set<String> m_ueiList;

        ListenerKeeper(EventListener listener, Set<String> ueiList) {
            this.m_listener = listener;
            this.m_ueiList = ueiList;
        }

        public int hashCode() {
            return new HashCodeBuilder(27, 31).append((Object)this.m_listener).append(this.m_ueiList).toHashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof ListenerKeeper) {
                ListenerKeeper keeper = (ListenerKeeper)o;
                return this.m_listener.equals(keeper.m_listener) && (this.m_ueiList == null ? keeper.m_ueiList == null : this.m_ueiList.equals(keeper.m_ueiList));
            }
            return false;
        }

        private boolean eventMatches(IEvent e) {
            if (this.m_ueiList == null) {
                return true;
            }
            return this.m_ueiList.contains(e.getUei());
        }

        public void sendEventIfAppropriate(IEvent e) {
            if (this.eventMatches(e)) {
                this.m_listener.onEvent(e);
            }
        }
    }

    public static interface SendNowHook {
        public void beforeBroadcast(org.opennms.netmgt.xml.event.Event var1);

        public void afterBroadcast(org.opennms.netmgt.xml.event.Event var1);

        public void finishProcessingEvents();
    }

    public static class EmptyEventConfDao
    implements EventConfDao {
        public void addEvent(Event event) {
        }

        public Event findByEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
            return null;
        }

        public Event findByUei(String uei) {
            return null;
        }

        public String getEventLabel(String uei) {
            return null;
        }

        public Map<String, String> getEventLabels() {
            return null;
        }

        public List<String> getEventUEIs() {
            return null;
        }

        public List<Event> getEvents(String uei) {
            return null;
        }

        public List<Event> getEventsByLabel() {
            return null;
        }

        public boolean isSecureTag(String tag) {
            return false;
        }

        public void reload() throws DataAccessException {
        }

        public Events getRootEvents() {
            return null;
        }

        public void loadEventsFromDB(List<EventConfEvent> dbEvents) {
        }
    }
}

