/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.matcher;

import com.google.common.base.Function;
import java.util.Objects;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.IpAddr;
import org.opennms.netmgt.flows.classification.internal.matcher.Matcher;
import org.opennms.netmgt.flows.classification.internal.value.IpValue;

class IpMatcher
implements Matcher {
    private final Function<ClassificationRequest, IpAddr> valueExtractor;
    private final IpValue value;

    protected IpMatcher(IpValue input, Function<ClassificationRequest, IpAddr> valueExtractor) {
        this.value = input;
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
    }

    @Override
    public boolean matches(ClassificationRequest request) {
        IpAddr addr = (IpAddr)this.valueExtractor.apply((Object)request);
        boolean matches = this.value.isInRange(addr);
        return matches;
    }
}

