/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.dao.healthcheck;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DaoHealthCheck
implements HealthCheck {
    private BundleContext bundleContext;

    public DaoHealthCheck(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public String getDescription() {
        return "Retrieving NodeDao";
    }

    public List<String> getTags() {
        return Arrays.asList("local", "dao");
    }

    public Response perform(Context context) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference("org.opennms.netmgt.dao.api.NodeDao");
        if (serviceReference != null) {
            return new Response(Status.Success);
        }
        return new Response(Status.Failure, "No NodeDao available");
    }
}

