/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.snmp4j.AbstractTarget;
import org.snmp4j.CertifiedTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.tls.PropertiesTlsTmSecurityCallback;
import org.snmp4j.transport.tls.X509TlsTransportMappingConfig;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;

public class SnmpConfigurator {
    public static final String O_VERSION = "v";
    public static final String P_VERSION = "org.snmp4j.arg.version";
    public static final String F_VERSION = "s<1|2c|3>";
    public static final String O_LOCAL_ENGINE_ID = "l";
    public static final String P_LOCAL_ENGINE_ID = "org.snmp4j.arg.localEngineID";
    public static final String F_LOCAL_ENGINE_ID = "o<\\n\\n[:\\n\\n]*>";
    public static final String O_AUTHORITATIVE_ENGINE_ID = "e";
    public static final String P_AUTHORITATIVE_ENGINE_ID = "org.snmp4j.arg.authoritativeEngineID";
    public static final String F_AUTHORITATIVE_ENGINE_ID = "o<\\n\\n[:\\n\\n]*>";
    public static final String O_COMMUNITY = "c";
    public static final String P_COMMUNITY = "org.snmp4j.arg.community";
    public static final String F_COMMUNITY = "s{=public}";
    public static final String O_CONTEXT_NAME = "n";
    public static final String P_CONTEXT_NAME = "org.snmp4j.arg.contextName";
    public static final String F_CONTEXT_NAME = "s{=}";
    public static final String O_CONTEXT_ENGINE_ID = "E";
    public static final String P_CONTEXT_ENGINE_ID = "org.snmp4j.arg.contextEngineID";
    public static final String F_CONTEXT_ENGINE_ID = "o<\\n\\n[:\\n\\n]*>";
    public static final String O_SECURITY_NAME = "u";
    public static final String P_SECURITY_NAME = "org.snmp4j.arg.securityName";
    public static final String F_SECURITY_NAME = "s";
    public static final String O_RETRIES = "r";
    public static final String P_RETRIES = "org.snmp4j.arg.retries";
    public static final String F_RETRIES = "i";
    public static final String O_TIMEOUT = "t";
    public static final String P_TIMEOUT = "org.snmp4j.arg.timeout";
    public static final String F_TIMEOUT = "l";
    public static final String O_ADDRESS = "address";
    public static final String P_ADDRESS = "org.snmp4j.arg.address";
    public static final String F_ADDRESS = "s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>";
    public static final String O_BIND_ADDRESS = "b";
    public static final String P_BIND_ADDRESS = "org.snmp4j.arg.bindAddress";
    public static final String F_BIND_ADDRESS = "s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>";
    public static final String O_AUTH_PASSPHRASE = "A";
    public static final String P_AUTH_PASSPHRASE = "org.snmp4j.arg.authPassphrase";
    public static final String F_AUTH_PASSPHRASE = "s<.*>";
    public static final String O_PRIV_PASSPHRASE = "Y";
    public static final String P_PRIV_PASSPHRASE = "org.snmp4j.arg.privPassphrase";
    public static final String F_PRIV_PASSPHRASE = "s<.*>";
    public static final String O_AUTH_PROTOCOL = "a";
    public static final String P_AUTH_PROTOCOL = "org.snmp4j.arg.authProtocol";
    public static final String F_AUTH_PROTOCOL = "s<(MD5|SHA|SHA224|SHA256|SHA384|SHA512)>";
    public static final String O_PRIV_PROTOCOL = "y";
    public static final String P_PRIV_PROTOCOL = "org.snmp4j.arg.privProtocol";
    public static final String F_PRIV_PROTOCOL = "s<(DES|3DES|AES|AES128|AES192|AES256)>";
    public static final String O_OPERATION = "o";
    public static final String P_OPERATION = "org.snmp4j.arg.operation";
    public static final String F_OPERATION = "s<(?i)(GET|GETNEXT|GETBULK|TRAP|NOTIFICATION|SET|INFORM)>";
    public static final String O_MAX_REPETITIONS = "Cr";
    public static final String P_MAX_REPETITIONS = "org.snmp4j.arg.maxRepetitions";
    public static final String F_MAX_REPETITIONS = "i{=10}";
    public static final String O_NON_REPEATERS = "Cn";
    public static final String P_NON_REPEATERS = "org.snmp4j.arg.nonRepeaters";
    public static final String F_NON_REPEATERS = "i{=0}";
    public static final String O_TRAPV1_AGENT_ADDR = "Ta";
    public static final String P_TRAPV1_AGENT_ADDR = "org.snmp4j.arg.trapv1.agentAddr";
    public static final String F_TRAPV1_AGENT_ADDR = "s{=0.0.0.0}<\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}>";
    public static final String O_TRAP_OID = "To";
    public static final String P_TRAP_OID = "org.snmp4j.arg.trap.trapOID";
    public static final String F_TRAP_OID = "s{=1.3.6.1.6.3.1.1.5.1}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>";
    public static final String O_TRAP_UPTIME = "Tu";
    public static final String P_TRAP_UPTIME = "org.snmp4j.arg.trap.trapUpTime";
    public static final String F_TRAP_UPTIME = "l{=0}";
    public static final String O_TRAPV1_ENTERPRISE = "Te";
    public static final String P_TRAPV1_ENTERPRISE = "org.snmp4j.arg.trap.trapv1.enterprise";
    public static final String F_TRAPV1_ENTERPRISE = "s{=0.0}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>";
    public static final String O_TRAPV1_SPECIFIC_ID = "Ts";
    public static final String P_TRAPV1_SPECIFIC_ID = "org.snmp4j.arg.trap.trapv1.specificID";
    public static final String F_TRAPV1_SPECIFIC_ID = "i{=0}";
    public static final String O_TRAPV1_GENERIC_ID = "Tg";
    public static final String P_TRAPV1_GENERIC_ID = "org.snmp4j.arg.trap.trapv1.genericID";
    public static final String F_TRAPV1_GENERIC_ID = "i{=0}";
    public static final String O_BOOT_COUNTER = "bc";
    public static final String P_BOOT_COUNTER = "org.snmp4j.arg.bootCounter";
    public static final String F_BOOT_COUNTER = "i{=0}";
    public static final String O_SEC_LEVEL = "sl";
    public static final String P_SEC_LEVEL = "org.snmp4j.arg.securityLevel";
    public static final String F_SEC_LEVEL = "i";
    public static final String O_SEC_MODEL = "sm";
    public static final String P_SEC_MODEL = "org.snmp4j.arg.securityModel";
    public static final String F_SEC_MODEL = "i";
    public static final String O_TLS_LOCAL_ID = "tls-local-id";
    public static final String P_TLS_LOCAL_ID = "org.snmp4j.arg.tlsLocalID";
    public static final String F_TLS_LOCAL_ID = "s";
    public static final String O_TLS_PEER_ID = "tls-peer-id";
    public static final String P_TLS_PEER_ID = "org.snmp4j.arg.tlsPeerID";
    public static final String F_TLS_PEER_ID = "s";
    public static final String O_TLS_CERT_FINGERPRINT = "tls-cert-fingerprint";
    public static final String P_TLS_CERT_FINGERPRINT = "org.snmp4j.arg.tlsCertFingerprint";
    public static final String F_TLS_CERT_FINGERPRINT = "o<\\n\\n[:\\n\\n]*>";
    public static final String O_TLS_TRUST_CA = "tls-trust-ca";
    public static final String P_TLS_TRUST_CA = "org.snmp4j.arg.tlsTrustCA";
    public static final String F_TLS_TRUST_CA = "s";
    public static final String O_TLS_VERSION = "tls-version";
    public static final String P_TLS_VERSION = "org.snmp4j.arg.tlsVersion";
    public static final String F_TLS_VERSION = "s{=TLSv1.2}<TLSv1[\\.1|\\.2|\\.3]?[,TLSv1[\\.1|\\.2|\\.3]?]*>";
    public static final String O_DTLS_VERSION = "dtls-version";
    public static final String P_DTLS_VERSION = "org.snmp4j.arg.dtlsVersion";
    public static final String F_DTLS_VERSION = "s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>";
    private String oVersion;
    private String oLocalEngineID;
    private String oRetries;
    private String oTimeout;
    private String oAddress;
    private String oBindAddress;
    private String oCommunity;
    private String oAuthoritativeEngineID;
    private String oSecurityName;
    private String oAuthPassphrase;
    private String oAuthProtocol;
    private String oPrivPassphrase;
    private String oPrivProtocol;
    private String oOperation;
    private String oMaxRepetitions;
    private String oNonRepeaters;
    private String oBootCounter;
    private String oContextName;
    private String oContextEngineID;
    private String oSecLevel;
    private String oSecModel;
    private String oAgentAddr;
    private String oTrapOID;
    private String oTrapSysUpTime;
    private String oGenericID;
    private String oSpecificID;
    private String oEnterprise;
    private String oTlsLocalID;
    private String oTlsTrustCA;
    private String oTlsPeerID;
    private String oTlsVersion;
    private String oDtlsVersion;
    private String oTlsCertFingerprint;
    private boolean commandResponder;

    public SnmpConfigurator() {
        this(new Properties());
    }

    public SnmpConfigurator(Properties props) {
        this.oVersion = props.getProperty(P_VERSION, O_VERSION);
        this.oLocalEngineID = props.getProperty(P_LOCAL_ENGINE_ID, "l");
        this.oRetries = props.getProperty(P_RETRIES, O_RETRIES);
        this.oTimeout = props.getProperty(P_TIMEOUT, O_TIMEOUT);
        this.oAddress = props.getProperty(P_ADDRESS, O_ADDRESS);
        this.oBindAddress = props.getProperty(P_BIND_ADDRESS, O_BIND_ADDRESS);
        this.oCommunity = props.getProperty(P_COMMUNITY, O_COMMUNITY);
        this.oSecurityName = props.getProperty(P_SECURITY_NAME, O_SECURITY_NAME);
        this.oAuthoritativeEngineID = props.getProperty(P_AUTHORITATIVE_ENGINE_ID, O_AUTHORITATIVE_ENGINE_ID);
        this.oAuthPassphrase = props.getProperty(P_AUTH_PASSPHRASE, O_AUTH_PASSPHRASE);
        this.oAuthProtocol = props.getProperty(P_AUTH_PROTOCOL, O_AUTH_PROTOCOL);
        this.oPrivPassphrase = props.getProperty(P_PRIV_PASSPHRASE, O_PRIV_PASSPHRASE);
        this.oPrivProtocol = props.getProperty(P_PRIV_PROTOCOL, O_PRIV_PROTOCOL);
        this.oOperation = props.getProperty(P_OPERATION, O_OPERATION);
        this.oMaxRepetitions = props.getProperty(P_MAX_REPETITIONS, O_MAX_REPETITIONS);
        this.oNonRepeaters = props.getProperty(P_NON_REPEATERS, O_NON_REPEATERS);
        this.oBootCounter = props.getProperty(P_BOOT_COUNTER, O_BOOT_COUNTER);
        this.oContextName = props.getProperty(P_CONTEXT_NAME, O_CONTEXT_NAME);
        this.oContextEngineID = props.getProperty(P_CONTEXT_ENGINE_ID, O_CONTEXT_ENGINE_ID);
        this.oSecLevel = props.getProperty(P_SEC_LEVEL, O_SEC_LEVEL);
        this.oSecModel = props.getProperty(P_SEC_MODEL, O_SEC_MODEL);
        this.oAgentAddr = props.getProperty(P_TRAPV1_AGENT_ADDR, O_TRAPV1_AGENT_ADDR);
        this.oTrapOID = props.getProperty(P_TRAP_OID, O_TRAP_OID);
        this.oTrapSysUpTime = props.getProperty(P_TRAP_UPTIME, O_TRAP_UPTIME);
        this.oSpecificID = props.getProperty(P_TRAPV1_SPECIFIC_ID, O_TRAPV1_SPECIFIC_ID);
        this.oGenericID = props.getProperty(P_TRAPV1_GENERIC_ID, O_TRAPV1_GENERIC_ID);
        this.oEnterprise = props.getProperty(P_TRAPV1_ENTERPRISE, O_TRAPV1_ENTERPRISE);
        this.oTlsLocalID = props.getProperty(P_TLS_LOCAL_ID, O_TLS_LOCAL_ID);
        this.oTlsPeerID = props.getProperty(P_TLS_PEER_ID, O_TLS_PEER_ID);
        this.oTlsTrustCA = props.getProperty(P_TLS_TRUST_CA, O_TLS_TRUST_CA);
        this.oTlsVersion = props.getProperty(P_TLS_VERSION, O_TLS_VERSION);
        this.oDtlsVersion = props.getProperty(P_DTLS_VERSION, O_DTLS_VERSION);
        this.oTlsCertFingerprint = props.getProperty(P_TLS_CERT_FINGERPRINT, O_TLS_CERT_FINGERPRINT);
    }

    public SnmpConfigurator(boolean commandResponder) {
        this();
        this.commandResponder = commandResponder;
    }

    public SnmpConfigurator(Properties props, boolean commandResponder) {
        this(props);
        this.commandResponder = commandResponder;
    }

    public boolean isCommandResponder() {
        return this.commandResponder;
    }

    public void setCommandResponder(boolean commandResponder) {
        this.commandResponder = commandResponder;
    }

    public void configure(Snmp snmp, Map<String, List<Object>> settings) {
        this.configure(snmp, snmp.getUSM(), snmp.getMessageDispatcher(), settings);
    }

    public void configure(Snmp snmp, USM usm, MessageDispatcher messageDispatcher, Map<String, List<Object>> settings) {
        if (usm != null) {
            this.configureEngine(snmp, usm, settings);
            String sn = (String)ArgumentParser.getValue(settings, this.oSecurityName, 0);
            if (sn != null) {
                String authPP = (String)ArgumentParser.getValue(settings, this.oAuthPassphrase, 0);
                String privPP = (String)ArgumentParser.getValue(settings, this.oPrivPassphrase, 0);
                String authP = (String)ArgumentParser.getValue(settings, this.oAuthProtocol, 0);
                String privP = (String)ArgumentParser.getValue(settings, this.oPrivProtocol, 0);
                OID authProtocol = SnmpConfigurator.getAuthProtocolOid(authP);
                OID privProtocol = SnmpConfigurator.getPrivProtocolOid(privP);
                OctetString un = SnmpConfigurator.createOctetString(sn, null);
                usm.addUser(un, new UsmUser(un, authProtocol, SnmpConfigurator.createOctetString(authPP, null), privProtocol, SnmpConfigurator.createOctetString(privPP, null)));
            }
        }
        Properties tlsProps = this.getTlsProperties(settings);
        for (TransportMapping tm : messageDispatcher.getTransportMappings()) {
            if (!(tm instanceof X509TlsTransportMappingConfig)) continue;
            X509TlsTransportMappingConfig tlsTM = (X509TlsTransportMappingConfig)((Object)tm);
            tlsTM.setSecurityCallback(new PropertiesTlsTmSecurityCallback(tlsProps, this.commandResponder));
            if (tlsProps.getProperty(tlsTM.getProtocolVersionPropertyName()) == null) continue;
            String[] versions = tlsProps.getProperty(tlsTM.getProtocolVersionPropertyName()).split(",");
            tlsTM.setProtocolVersions(versions);
        }
    }

    public static OID getPrivProtocolOid(String privP) {
        OID privProtocol = null;
        if ("DES".equals(privP)) {
            privProtocol = PrivDES.ID;
        } else if ("3DES".equals(privP)) {
            privProtocol = Priv3DES.ID;
        } else if ("AES".equals(privP) || "AES128".equals(privP)) {
            privProtocol = PrivAES128.ID;
        } else if ("AES192".equals(privP)) {
            privProtocol = PrivAES192.ID;
        } else if ("AES256".equals(privP)) {
            privProtocol = PrivAES256.ID;
        } else if ("AES192p".equals(privP)) {
            privProtocol = PrivAES192With3DESKeyExtension.ID;
        } else if ("AES256p".equals(privP)) {
            privProtocol = PrivAES256With3DESKeyExtension.ID;
        }
        return privProtocol;
    }

    public static OID getAuthProtocolOid(String authP) {
        OID authProtocol = null;
        if ("MD5".equals(authP)) {
            authProtocol = AuthMD5.ID;
        } else if ("SHA".equals(authP)) {
            authProtocol = AuthSHA.ID;
        } else if ("SHA224".equals(authP)) {
            authProtocol = AuthHMAC128SHA224.ID;
        } else if ("SHA256".equals(authP)) {
            authProtocol = AuthHMAC192SHA256.ID;
        } else if ("SHA384".equals(authP)) {
            authProtocol = AuthHMAC256SHA384.ID;
        } else if ("SHA512".equals(authP)) {
            authProtocol = AuthHMAC384SHA512.ID;
        }
        return authProtocol;
    }

    private void configureEngine(Snmp snmp, USM usm, Map<String, List<Object>> settings) {
        int engineBoots = 0;
        Integer bc = (Integer)ArgumentParser.getValue(settings, this.oBootCounter, 0);
        if (bc != null) {
            engineBoots = bc;
            usm.setEngineBoots(engineBoots);
        }
        int engineTime = 0;
        OctetString localEngineID = SnmpConfigurator.createOctetString((String)ArgumentParser.getValue(settings, this.oLocalEngineID, 0), null);
        if (localEngineID == null) {
            if (snmp.getLocalEngineID() == null) {
                snmp.setLocalEngine(MPv3.createLocalEngineID(), engineBoots, engineTime);
            }
        } else {
            snmp.setLocalEngine(localEngineID.getValue(), engineBoots, engineTime);
        }
    }

    private Properties getTlsProperties(Map<String, List<Object>> settings) {
        String tlsCertFingerprint;
        String dtlsVersion;
        String tlsVersion;
        String sn;
        String tlsPeerID;
        String tlsTrustCA;
        Properties tlsProps = new Properties();
        String tlsLocalID = (String)ArgumentParser.getValue(settings, this.oTlsLocalID, 0);
        if (tlsLocalID != null) {
            tlsProps.setProperty(P_TLS_LOCAL_ID, tlsLocalID);
        }
        if ((tlsTrustCA = (String)ArgumentParser.getValue(settings, this.oTlsTrustCA, 0)) != null) {
            tlsProps.setProperty(P_TLS_TRUST_CA, tlsTrustCA);
        }
        if ((tlsPeerID = (String)ArgumentParser.getValue(settings, this.oTlsPeerID, 0)) != null) {
            tlsProps.setProperty(P_TLS_PEER_ID, tlsPeerID);
        }
        if ((sn = (String)ArgumentParser.getValue(settings, this.oSecurityName, 0)) != null) {
            tlsProps.setProperty(P_SECURITY_NAME, sn);
        }
        if ((tlsVersion = (String)ArgumentParser.getValue(settings, this.oTlsVersion, 0)) != null) {
            tlsProps.setProperty(P_TLS_VERSION, tlsVersion);
        }
        if ((dtlsVersion = (String)ArgumentParser.getValue(settings, this.oDtlsVersion, 0)) != null) {
            tlsProps.setProperty(P_DTLS_VERSION, dtlsVersion);
        }
        if ((tlsCertFingerprint = (String)ArgumentParser.getValue(settings, this.oTlsCertFingerprint, 0)) != null) {
            tlsProps.setProperty(P_TLS_CERT_FINGERPRINT, tlsCertFingerprint);
        }
        return tlsProps;
    }

    public PDUFactory getPDUFactory(Map<String, List<Object>> settings) {
        return new InnerPDUFactory(settings);
    }

    public Target getTarget(Map<String, List<Object>> settings) {
        AbstractTarget t;
        String version = (String)ArgumentParser.getValue(settings, this.oVersion, 0);
        OctetString community = SnmpConfigurator.createOctetString((String)ArgumentParser.getValue(settings, this.oCommunity, 0), "public");
        Integer securityModel = (Integer)ArgumentParser.getValue(settings, this.oSecModel, 0);
        if ("1".equals(version)) {
            t = new CommunityTarget();
            t.setVersion(0);
            ((CommunityTarget)t).setCommunity(community);
        } else if ("2c".equals(version)) {
            t = new CommunityTarget();
            t.setVersion(1);
            ((CommunityTarget)t).setCommunity(community);
        } else if (securityModel != null && securityModel == 4 || securityModel == null && this.getTlsProperties(settings).size() > 1) {
            String sn = (String)ArgumentParser.getValue(settings, this.oSecurityName, 0);
            if (sn == null) {
                throw new IllegalArgumentException("Mandatory securityName for TLS target not specified with option -" + this.oSecurityName);
            }
            CertifiedTarget ct = new CertifiedTarget(new OctetString(sn));
            ct.setSecurityModel(4);
            this.setSecurityLevelOnTarget(settings, ct);
            t = ct;
        } else {
            UserTarget ut = new UserTarget();
            t = ut;
            String ae = (String)ArgumentParser.getValue(settings, this.oAuthoritativeEngineID, 0);
            if (ae != null) {
                ut.setAuthoritativeEngineID(SnmpConfigurator.createOctetString(ae, null).getValue());
            }
            ut.setSecurityModel(3);
            String sn = (String)ArgumentParser.getValue(settings, this.oSecurityName, 0);
            if (sn != null) {
                ut.setSecurityName(SnmpConfigurator.createOctetString(sn, null));
            }
            this.setSecurityLevelOnTarget(settings, ut);
        }
        int retries = 0;
        Number r = (Number)ArgumentParser.getValue(settings, this.oRetries, 0);
        if (r != null) {
            retries = r.intValue();
        }
        t.setRetries(retries);
        long timeout = 5000L;
        Number to = (Number)ArgumentParser.getValue(settings, this.oTimeout, 0);
        if (to != null) {
            timeout = to.longValue();
        }
        t.setTimeout(timeout);
        String addr = (String)ArgumentParser.getValue(settings, this.oAddress, 0);
        if (addr != null) {
            if (addr.indexOf(47) <= 0) {
                addr = addr + "/161";
            }
            t.setAddress(GenericAddress.parse(addr));
        }
        return t;
    }

    private void setSecurityLevelOnTarget(Map<String, List<Object>> settings, AbstractTarget target) {
        Integer secLevel = (Integer)ArgumentParser.getValue(settings, this.oSecLevel, 0);
        if (secLevel == null) {
            if (settings.containsKey(this.oPrivPassphrase) || target instanceof CertifiedTarget) {
                target.setSecurityLevel(3);
            } else if (settings.containsKey(this.oAuthPassphrase)) {
                target.setSecurityLevel(2);
            } else {
                target.setSecurityLevel(1);
            }
        } else {
            target.setSecurityLevel(secLevel);
        }
    }

    public Address getBindAddress(Map<String, List<Object>> settings) {
        String addr = (String)ArgumentParser.getValue(settings, this.oBindAddress, 0);
        if (addr != null) {
            if (addr.indexOf(47) <= 0) {
                addr = addr + "/0";
            }
            return GenericAddress.parse(addr);
        }
        return null;
    }

    public static OctetString createOctetString(String s, String defaultString) {
        OctetString octetString = null;
        if (s == null) {
            s = defaultString;
        }
        if (s != null && s.startsWith("0x")) {
            octetString = OctetString.fromHexString(s.substring(2), ':');
        } else if (s != null) {
            octetString = new OctetString(s);
        }
        return octetString;
    }

    public class InnerPDUFactory
    implements PDUFactory {
        private Map<String, List<Object>> settings;

        public InnerPDUFactory(Map<String, List<Object>> settings) {
            this.settings = settings;
        }

        @Override
        public PDU createPDU(Target target) {
            int type = this.getPduType();
            PDU pdu = DefaultPDUFactory.createPDU(target, type);
            this.configurePDU(type, pdu);
            return pdu;
        }

        private void configurePDU(int type, PDU pdu) {
            if (type == -92 && !(pdu instanceof PDUv1)) {
                throw new RuntimeException("V1TRAP can only be sent using SNMPv1");
            }
            if (type == -91) {
                Integer nonRepeaters;
                Integer maxRep = this.getMaxRepetitions();
                if (maxRep != null) {
                    pdu.setMaxRepetitions(maxRep);
                }
                if ((nonRepeaters = this.getNonRepeaters()) != null) {
                    pdu.setNonRepeaters(nonRepeaters);
                }
            } else if (type == -89 || type == -90) {
                String to;
                Number tu = (Number)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oTrapSysUpTime, 0);
                if (tu != null) {
                    pdu.add(new VariableBinding(SnmpConstants.sysUpTime, new TimeTicks(tu.longValue())));
                }
                if ((to = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oTrapOID, 0)) != null) {
                    pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, new OID(to)));
                }
            } else if (type == -92) {
                String e;
                Integer sid;
                Integer gid;
                PDUv1 pduV1 = (PDUv1)pdu;
                String aa = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oAgentAddr, 0);
                if (aa != null) {
                    pduV1.setAgentAddress(new IpAddress(aa));
                }
                if ((gid = (Integer)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oGenericID, 0)) != null) {
                    pduV1.setGenericTrap(gid);
                }
                if ((sid = (Integer)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oSpecificID, 0)) != null) {
                    pduV1.setSpecificTrap(sid);
                }
                if ((e = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oEnterprise, 0)) != null) {
                    pduV1.setEnterprise(new OID(e));
                }
            }
            if (pdu instanceof ScopedPDU) {
                String cn;
                ScopedPDU scoped = (ScopedPDU)pdu;
                String cEngineID = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oContextEngineID, 0);
                if (cEngineID != null) {
                    scoped.setContextEngineID(SnmpConfigurator.createOctetString(cEngineID, null));
                }
                if ((cn = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oContextName, 0)) != null) {
                    scoped.setContextName(SnmpConfigurator.createOctetString(cn, null));
                }
            }
        }

        private int getPduType() {
            String pduType = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oOperation, 0);
            if (pduType == null) {
                pduType = "GET";
            }
            pduType = pduType.toUpperCase();
            return PDU.getTypeFromString(pduType);
        }

        @Override
        public PDU createPDU(MessageProcessingModel messageProcessingModel) {
            int type = this.getPduType();
            PDU pdu = DefaultPDUFactory.createPDU(messageProcessingModel, type);
            this.configurePDU(type, pdu);
            return pdu;
        }

        public Integer getMaxRepetitions() {
            return (Integer)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oMaxRepetitions, 0);
        }

        public Integer getNonRepeaters() {
            return (Integer)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oNonRepeaters, 0);
        }
    }
}

