/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client.model;

import java.util.ArrayList;
import java.util.List;
import org.opennms.features.elastic.client.model.BulkOperation;

public class BulkRequest {
    private final List<BulkOperation> operations = new ArrayList<BulkOperation>();
    private int retryCount = 0;
    private String refresh = null;

    public BulkRequest add(BulkOperation operation) {
        this.operations.add(operation);
        return this;
    }

    public BulkRequest add(BulkOperation.Type type, String index, String id, Object source) {
        this.operations.add(new BulkOperation(type, index, id, source));
        return this;
    }

    public BulkRequest index(String index, String id, Object source) {
        return this.add(BulkOperation.index(index, id, source));
    }

    public BulkRequest update(String index, String id, Object source) {
        return this.add(BulkOperation.update(index, id, source));
    }

    public BulkRequest delete(String index, String id) {
        return this.add(BulkOperation.delete(index, id));
    }

    public List<BulkOperation> getOperations() {
        return this.operations;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getRefresh() {
        return this.refresh;
    }

    public void setRefresh(String refresh) {
        this.refresh = refresh;
    }

    public int size() {
        return this.operations.size();
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public void clear() {
        this.operations.clear();
    }
}

