/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.event;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.events.api.model.IAlarmData;
import org.opennms.netmgt.xml.event.ManagedObject;
import org.opennms.netmgt.xml.event.OnmsStringBuilder;
import org.opennms.netmgt.xml.event.UpdateField;

@XmlRootElement(name="alarm-data")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AlarmData
implements Serializable {
    private static final long serialVersionUID = 3681502418413339216L;
    @XmlAttribute(name="reduction-key", required=true)
    @NotNull
    private String _reductionKey;
    @XmlAttribute(name="alarm-type", required=true)
    @NotNull
    @Min(value=1L)
    private Integer _alarmType;
    @XmlAttribute(name="clear-key")
    private String _clearKey;
    @XmlAttribute(name="auto-clean")
    private Boolean _autoClean = false;
    @XmlAttribute(name="x733-alarm-type")
    private String _x733AlarmType;
    @XmlAttribute(name="x733-probable-cause")
    private Integer _x733ProbableCause;
    @XmlElement(name="update-field", required=false)
    @Valid
    private List<UpdateField> m_updateFieldList = new ArrayList<UpdateField>();
    @XmlElement(name="managed-object", required=false)
    private ManagedObject m_managedObject;

    public static AlarmData copyFrom(IAlarmData source) {
        if (source == null) {
            return null;
        }
        AlarmData alarmData = new AlarmData();
        alarmData.setReductionKey(source.getReductionKey());
        alarmData.setAlarmType(source.hasAlarmType() ? source.getAlarmType() : null);
        alarmData.setClearKey(source.getClearKey());
        alarmData.setAutoClean(source.hasAutoClean() ? source.getAutoClean() : null);
        alarmData.setX733AlarmType(source.getX733AlarmType());
        alarmData.setX733ProbableCause(source.hasX733ProbableCause() ? source.getX733ProbableCause() : null);
        alarmData.getUpdateFieldList().addAll(source.getUpdateFieldList().stream().map(UpdateField::copyFrom).collect(Collectors.toList()));
        alarmData.setManagedObject(ManagedObject.copyFrom(source.getManagedObject()));
        return alarmData;
    }

    public void deleteAlarmType() {
        this._alarmType = null;
    }

    public void deleteAutoClean() {
        this._autoClean = null;
    }

    public void deleteX733ProbableCause() {
        this._x733ProbableCause = null;
    }

    public Integer getAlarmType() {
        return this._alarmType == null ? 0 : this._alarmType;
    }

    public Boolean getAutoClean() {
        return this._autoClean == null ? false : this._autoClean;
    }

    public String getClearKey() {
        return this._clearKey;
    }

    public String getReductionKey() {
        return this._reductionKey;
    }

    public String getX733AlarmType() {
        return this._x733AlarmType;
    }

    public Integer getX733ProbableCause() {
        return this._x733ProbableCause == null ? 0 : this._x733ProbableCause;
    }

    public boolean hasAlarmType() {
        return this._alarmType != null;
    }

    public boolean hasAutoClean() {
        return this._autoClean != null;
    }

    public boolean hasX733ProbableCause() {
        return this._x733ProbableCause != null;
    }

    public Boolean isAutoClean() {
        return this.getAutoClean();
    }

    public void setAlarmType(Integer alarmType) {
        this._alarmType = alarmType;
    }

    public void setAutoClean(Boolean autoClean) {
        this._autoClean = autoClean;
    }

    public void setClearKey(String clearKey) {
        this._clearKey = clearKey;
    }

    public void setReductionKey(String reductionKey) {
        this._reductionKey = reductionKey;
    }

    public void setX733AlarmType(String x733AlarmType) {
        this._x733AlarmType = x733AlarmType;
    }

    public void setX733ProbableCause(Integer x733ProbableCause) {
        this._x733ProbableCause = x733ProbableCause;
    }

    public UpdateField[] getUpdateField() {
        return this.m_updateFieldList.toArray(new UpdateField[0]);
    }

    public Collection<UpdateField> getUpdateFieldCollection() {
        return this.m_updateFieldList;
    }

    public List<UpdateField> getUpdateFieldList() {
        return this.m_updateFieldList;
    }

    public int getUpdateFieldListCount() {
        return this.m_updateFieldList.size();
    }

    public Boolean hasUpdateFields() {
        Boolean hasFields = true;
        if (this.m_updateFieldList == null || this.m_updateFieldList.isEmpty()) {
            hasFields = false;
        }
        return hasFields;
    }

    @Hidden
    public void setUpdateField(UpdateField[] fields) {
        this.m_updateFieldList.clear();
        for (int i = 0; i < fields.length; ++i) {
            this.m_updateFieldList.add(fields[i]);
        }
    }

    public void setUpdateField(List<UpdateField> fields) {
        if (this.m_updateFieldList == fields) {
            return;
        }
        this.m_updateFieldList.clear();
        this.m_updateFieldList.addAll(fields);
    }

    @Hidden
    public void setUpdateFieldCollection(Collection<UpdateField> fields) {
        if (this.m_updateFieldList == fields) {
            return;
        }
        this.m_updateFieldList.clear();
        this.m_updateFieldList.addAll(fields);
    }

    public ManagedObject getManagedObject() {
        return this.m_managedObject;
    }

    public void setManagedObject(ManagedObject m_managedObject) {
        this.m_managedObject = m_managedObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmData alarmData = (AlarmData)o;
        return Objects.equals(this._reductionKey, alarmData._reductionKey) && Objects.equals(this._alarmType, alarmData._alarmType) && Objects.equals(this._clearKey, alarmData._clearKey) && Objects.equals(this._autoClean, alarmData._autoClean) && Objects.equals(this._x733AlarmType, alarmData._x733AlarmType) && Objects.equals(this._x733ProbableCause, alarmData._x733ProbableCause) && Objects.equals(this.m_updateFieldList, alarmData.m_updateFieldList) && Objects.equals(this.m_managedObject, alarmData.m_managedObject);
    }

    public int hashCode() {
        return Objects.hash(this._reductionKey, this._alarmType, this._clearKey, this._autoClean, this._x733AlarmType, this._x733ProbableCause, this.m_updateFieldList, this.m_managedObject);
    }

    public String toString() {
        return new OnmsStringBuilder(this).toString();
    }
}

