/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.ops4j.pax.transx.connection.utils.AbstractConnectionHandle;
import org.ops4j.pax.transx.jms.impl.ConnectionRequestInfoImpl;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionFactoryImpl;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionImpl;
import org.ops4j.pax.transx.jms.impl.SessionImpl;
import org.ops4j.pax.transx.jms.impl.Utils;

public class ConnectionImpl
implements TopicConnection,
QueueConnection {
    private final ManagedConnectionFactoryImpl mcf;
    private final ConnectionManager cm;
    private final String userName;
    private final String password;
    private final String clientID;
    private final Set<TemporaryQueue> tempQueues = new HashSet<TemporaryQueue>();
    private final Set<TemporaryTopic> tempTopics = new HashSet<TemporaryTopic>();
    private SessionImpl session;
    private boolean closed;
    private boolean started;

    public ConnectionImpl(ManagedConnectionFactoryImpl mcf, ConnectionManager cm, String userName, String password, String clientID) {
        this.mcf = mcf;
        this.cm = cm;
        this.userName = userName;
        this.password = password;
        this.clientID = clientID;
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.doClose();
        }
    }

    private void doClose() {
        Optional.ofNullable(this.session).ifPresent(AbstractConnectionHandle::close);
        Utils.doClose(this.tempQueues, TemporaryQueue::delete);
        Utils.doClose(this.tempTopics, TemporaryTopic::delete);
    }

    synchronized void closeSession(SessionImpl session) {
        assert (this.session == session);
        this.session = null;
    }

    public synchronized void start() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (!this.started) {
            SessionImpl s = this.session;
            if (s != null) {
                s.start();
            }
            this.started = true;
        }
    }

    public void stop() throws JMSException {
        Utils.unsupported("stop");
    }

    public String getClientID() throws JMSException {
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        Utils.unsupported("setClientID");
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        ConnectionMetaData connectionMetaData;
        block8: {
            ConnectionRequestInfoImpl cri = new ConnectionRequestInfoImpl(false, 1, this.userName, this.password, this.clientID);
            SessionImpl session = (SessionImpl)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
            try {
                session.setConnection(this);
                connectionMetaData = ((ManagedConnectionImpl)session.getManagedConnection()).getConnectionMetaData();
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ResourceException e) {
                    throw (JMSException)new JMSException("Unable to retrieve metadata").initCause((Throwable)e);
                }
            }
            session.close();
        }
        return connectionMetaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return (ExceptionListener)Utils.unsupported("getExceptionListener");
    }

    public void setExceptionListener(ExceptionListener excptLstnr) throws JMSException {
        Utils.unsupported("setExceptionListener");
    }

    public ConnectionConsumer createConnectionConsumer(Destination dest, String msgSel, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        return (ConnectionConsumer)Utils.unsupported("createConnectionConsumer");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String subName, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        return (ConnectionConsumer)Utils.unsupported("createConnectionConsumer");
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String subName, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        return (ConnectionConsumer)Utils.unsupported("createConnectionConsumer");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subName, String msgSel, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        return (ConnectionConsumer)Utils.unsupported("createDurableConnectionConsumer");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return (ConnectionConsumer)Utils.unsupported("createSharedDurableConnectionConsumer");
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return (ConnectionConsumer)Utils.unsupported("createSharedDurableConnectionConsumer");
    }

    public Session createSession() throws JMSException {
        return this.createSession(false, 1);
    }

    public Session createSession(int sessionMode) throws JMSException {
        return this.createSession(sessionMode == 0, sessionMode);
    }

    public TopicSession createTopicSession(boolean transacted, int sessionMode) throws JMSException {
        return this.createSession(transacted, sessionMode);
    }

    public QueueSession createQueueSession(boolean transacted, int sessionMode) throws JMSException {
        return this.createSession(transacted, sessionMode);
    }

    public synchronized SessionImpl createSession(boolean transacted, int sessionMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (this.session != null) {
            throw new IllegalStateException("Only one session per connection is allowed");
        }
        try {
            ConnectionRequestInfoImpl cri = new ConnectionRequestInfoImpl(transacted, sessionMode, this.userName, this.password, this.clientID);
            SessionImpl session = (SessionImpl)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
            try {
                session.setConnection(this);
                if (this.started) {
                    session.start();
                }
                this.session = session;
                return session;
            }
            catch (Throwable t) {
                try {
                    session.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw t;
            }
        }
        catch (Exception e) {
            throw Utils.newJMSException(e);
        }
    }

    TemporaryQueue wrapTemporaryQueue(TemporaryQueue queue) {
        this.tempQueues.add(queue);
        return queue;
    }

    TemporaryTopic wrapTemporaryTopic(TemporaryTopic topic) {
        this.tempTopics.add(topic);
        return topic;
    }
}

