/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapIdentity {
    private static final transient Logger LOG = LoggerFactory.getLogger(TrapIdentity.class);
    private int m_generic;
    private int m_specific;
    private String m_enterpriseId;
    private String trapOID;
    private static final List<SnmpObjId> GENERIC_TRAPS = new ArrayList<SnmpObjId>();
    private static final Map<Integer, SnmpObjId> GENERIC_TRAPS_BY_GENERIC_ID;
    private static final char DOT_CHAR = '.';
    private static final String SNMP_TRAP_ENTERPRISE_ID = ".1.3.6.1.6.3.1.1.4.3.0";
    private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";

    public TrapIdentity(SnmpObjId snmpTrapOid, SnmpObjId lastVarBindOid, SnmpValue lastVarBindValue) {
        String snmpTrapOidValue = snmpTrapOid.toString();
        LOG.debug("snmpTrapOID: {}", (Object)snmpTrapOidValue);
        int lastIndex = snmpTrapOidValue.lastIndexOf(46);
        String lastSubIdStr = snmpTrapOidValue.substring(lastIndex + 1);
        int lastSubId = -1;
        try {
            lastSubId = Integer.parseInt(lastSubIdStr);
        }
        catch (NumberFormatException nfe) {
            lastSubId = -1;
        }
        if (GENERIC_TRAPS.contains(snmpTrapOid)) {
            this.setGeneric(lastSubId - 1);
            this.setSpecific(0);
            String varBindName = lastVarBindOid.toString();
            if (varBindName.equals(SNMP_TRAP_ENTERPRISE_ID)) {
                this.setEnterpriseId(lastVarBindValue.toString());
            } else {
                this.setEnterpriseId(".1.3.6.1.6.3.1.1.5." + snmpTrapOidValue.charAt(snmpTrapOidValue.length() - 1));
            }
            this.setTrapOID(this.getEnterpriseId());
        } else {
            this.setGeneric(6);
            this.setSpecific(lastSubId);
            int nextToLastIndex = snmpTrapOidValue.lastIndexOf(46, lastIndex - 1);
            String nextToLastSubIdStr = snmpTrapOidValue.substring(nextToLastIndex + 1, lastIndex);
            if (nextToLastSubIdStr.equals("0")) {
                this.setEnterpriseId(snmpTrapOidValue.substring(0, nextToLastIndex));
                this.setTrapOID(snmpTrapOidValue);
            } else {
                this.setEnterpriseId(snmpTrapOidValue.substring(0, lastIndex));
                this.setTrapOID(snmpTrapOidValue);
            }
        }
    }

    public TrapIdentity(SnmpObjId entId, int generic, int specific) {
        this.m_enterpriseId = entId.toString();
        this.m_generic = generic;
        this.m_specific = specific;
        if (this.m_generic == 6) {
            String trapOID = this.m_enterpriseId + ".0." + this.m_specific;
            this.setTrapOID(trapOID);
        } else if (GENERIC_TRAPS_BY_GENERIC_ID.containsKey(this.m_generic)) {
            SnmpObjId trapOID = GENERIC_TRAPS_BY_GENERIC_ID.get(this.m_generic);
            this.setTrapOID(trapOID.toString());
        } else {
            this.setTrapOID(this.getEnterpriseId());
        }
    }

    public int getGeneric() {
        return this.m_generic;
    }

    private void setGeneric(int generic) {
        this.m_generic = generic;
    }

    public int getSpecific() {
        return this.m_specific;
    }

    private void setSpecific(int specific) {
        this.m_specific = specific;
    }

    public String getEnterpriseId() {
        return this.m_enterpriseId;
    }

    private void setEnterpriseId(String enterpriseId) {
        this.m_enterpriseId = enterpriseId;
    }

    public String getTrapOID() {
        return this.trapOID;
    }

    private void setTrapOID(String trapOID) {
        this.trapOID = trapOID;
    }

    public String toString() {
        return "[Generic=" + this.getGeneric() + ", Specific=" + this.getSpecific() + ", EnterpriseId=" + this.getEnterpriseId() + "]";
    }

    static {
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.1"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.2"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.3"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.4"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.5"));
        GENERIC_TRAPS.add(new SnmpObjId("1.3.6.1.6.3.1.1.5.6"));
        GENERIC_TRAPS_BY_GENERIC_ID = new HashMap<Integer, SnmpObjId>();
        GENERIC_TRAPS_BY_GENERIC_ID.put(0, new SnmpObjId("1.3.6.1.6.3.1.1.5.1"));
        GENERIC_TRAPS_BY_GENERIC_ID.put(1, new SnmpObjId("1.3.6.1.6.3.1.1.5.2"));
        GENERIC_TRAPS_BY_GENERIC_ID.put(2, new SnmpObjId("1.3.6.1.6.3.1.1.5.3"));
        GENERIC_TRAPS_BY_GENERIC_ID.put(3, new SnmpObjId("1.3.6.1.6.3.1.1.5.4"));
        GENERIC_TRAPS_BY_GENERIC_ID.put(4, new SnmpObjId("1.3.6.1.6.3.1.1.5.5"));
        GENERIC_TRAPS_BY_GENERIC_ID.put(5, new SnmpObjId("1.3.6.1.6.3.1.1.5.6"));
    }
}

